/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.petrify;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.commons.io.output.FileWriterWithEncoding;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.io.parser.ParseException;
import uniol.apt.io.parser.impl.PetrifyPNParser;
import uniol.apt.io.renderer.impl.PetrifyLTSRenderer;
import uniol.apt.module.exception.FalseParameterException;
import uniol.apt.module.exception.ModuleException;
import uniol.apt.module.exception.PetrifyNotFoundException;

public class PetrifyLTSSynthesize {
    private final TransitionSystem ts_;
    private String errorMsg_;
    private PetriNet pn_;
    private String sndParameter_;

    public PetrifyLTSSynthesize(TransitionSystem ts) {
        this.ts_ = ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check() throws IOException, ModuleException {
        PetrifyLTSRenderer pf = new PetrifyLTSRenderer();
        String petrifyLts = pf.render(this.ts_);
        petrifyLts = petrifyLts + "\n";
        File tmpAutFile = null;
        try {
            Process p;
            Throwable throwable;
            tmpAutFile = File.createTempFile("petrifyAut", ".aut");
            try (FileWriterWithEncoding fw = new FileWriterWithEncoding(tmpAutFile, "UTF-8");){
                throwable = null;
                try (BufferedWriter bw = new BufferedWriter(fw);){
                    bw.write(petrifyLts);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add("petrify");
            parameters.add("-nolog");
            parameters.add("-p");
            parameters.add(tmpAutFile.getAbsolutePath());
            if (this.sndParameter_ != null) {
                if (this.sndParameter_.equals("dead")) {
                    parameters.add("-" + this.sndParameter_);
                } else {
                    throw new FalseParameterException();
                }
            }
            try {
                p = new ProcessBuilder(parameters).start();
            }
            catch (Exception e) {
                throw new PetrifyNotFoundException(e);
            }
            throwable = null;
            try (InputStreamReader errorStream = new InputStreamReader(p.getErrorStream(), "UTF-8");
                 BufferedReader error = new BufferedReader(errorStream);){
                try {
                    this.pn_ = new PetrifyPNParser().parse(p.getInputStream());
                }
                catch (ParseException e) {
                    throw new ModuleException(e);
                }
                String errorStr = error.readLine();
                if (errorStr != null) {
                    this.errorMsg_ = errorStr;
                    boolean bl = false;
                    return bl;
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (tmpAutFile != null) {
                tmpAutFile.delete();
            }
        }
    }

    public PetriNet getPN() {
        return this.pn_;
    }

    public String getError() {
        return this.errorMsg_;
    }

    public void setSndParameter(String par) {
        this.sndParameter_ = par;
    }
}

