/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.persistent;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class PersistentTS {
    private final TSWrapper wrapper;
    private boolean persistent = true;
    private State node_ = null;
    private String label1_ = null;
    private String label2_ = null;

    public PersistentTS(TransitionSystem ts, boolean backwards) {
        this.wrapper = !backwards ? new ForwardTSWrapper(ts) : new BackwardTSWrapper(ts);
        this.check();
    }

    public PersistentTS(TransitionSystem ts) {
        this(ts, false);
    }

    private void check() {
        for (State node : this.wrapper.getNodes()) {
            Map postset = this.wrapper.getStatePostset(node);
            LinkedList unhandledLabels = new LinkedList(postset.keySet());
            while (!unhandledLabels.isEmpty()) {
                String label1 = (String)unhandledLabels.removeFirst();
                Set statesAfterLabel1 = (Set)postset.get(label1);
                for (String label2 : unhandledLabels) {
                    InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                    HashSet statesAfter12 = new HashSet();
                    for (State node1 : statesAfterLabel1) {
                        statesAfter12.addAll(this.wrapper.getStatePostsetViaLabel(node1, label2));
                    }
                    boolean foundSharedState = false;
                    for (State node2 : (Set)postset.get(label2)) {
                        if (Collections.disjoint(statesAfter12, this.wrapper.getStatePostsetViaLabel(node2, label1))) continue;
                        foundSharedState = true;
                        break;
                    }
                    if (foundSharedState) continue;
                    this.persistent = false;
                    this.node_ = node;
                    this.label1_ = label1;
                    this.label2_ = label2;
                    return;
                }
            }
        }
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public State getNode() {
        return this.node_;
    }

    public String getLabel1() {
        return this.label1_;
    }

    public String getLabel2() {
        return this.label2_;
    }

    private class BackwardTSWrapper
    extends TSWrapper {
        private BackwardTSWrapper(TransitionSystem ts) {
            super(ts);
        }

        @Override
        protected Set<Arc> getPostsetEdges(State n) {
            return n.getPresetEdges();
        }

        @Override
        protected State getTarget(Arc arc) {
            return (State)arc.getSource();
        }
    }

    private class ForwardTSWrapper
    extends TSWrapper {
        private ForwardTSWrapper(TransitionSystem ts) {
            super(ts);
        }

        @Override
        protected Set<Arc> getPostsetEdges(State n) {
            return n.getPostsetEdges();
        }

        @Override
        protected State getTarget(Arc arc) {
            return (State)arc.getTarget();
        }
    }

    private abstract class TSWrapper {
        private final TransitionSystem ts;
        private final Map<State, Map<String, Set<State>>> statePostsetsCache = new HashMap<State, Map<String, Set<State>>>();

        private TSWrapper(TransitionSystem ts) {
            this.ts = ts;
        }

        private Set<State> getNodes() {
            return this.ts.getNodes();
        }

        private Map<String, Set<State>> getStatePostset(State node) {
            Map<String, Set<State>> result = this.statePostsetsCache.get(node);
            if (result != null) {
                return result;
            }
            result = new HashMap<String, Set<State>>();
            for (Arc arc : this.getPostsetEdges(node)) {
                Set<State> set = result.get(arc.getLabel());
                if (set == null) {
                    set = new HashSet<State>();
                    result.put(arc.getLabel(), set);
                }
                set.add(this.getTarget(arc));
            }
            result = Collections.unmodifiableMap(result);
            this.statePostsetsCache.put(node, result);
            return result;
        }

        private Set<State> getStatePostsetViaLabel(State node, String label) {
            Set<State> result = this.getStatePostset(node).get(label);
            if (result == null) {
                return Collections.emptySet();
            }
            return result;
        }

        protected abstract Set<Arc> getPostsetEdges(State var1);

        protected abstract State getTarget(Arc var1);
    }
}

