/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.persistent;

import uniol.apt.adt.pn.Marking;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.coverability.CoverabilityGraph;
import uniol.apt.analysis.exception.UnboundedException;
import uniol.apt.analysis.persistent.PersistentTS;

public class PersistentNet {
    private final PetriNet pn_;
    private final boolean backwards_;
    private boolean deterministic_ = false;
    private Marking marking_ = null;
    private String label1 = null;
    private String label2 = null;

    public PersistentNet(PetriNet pn, boolean backwards) {
        this.pn_ = pn;
        this.backwards_ = backwards;
    }

    public PersistentNet(PetriNet pn) {
        this(pn, false);
    }

    public void check() throws UnboundedException {
        TransitionSystem ts = CoverabilityGraph.get(this.pn_).toReachabilityLTS();
        PersistentTS ltsPersistent = new PersistentTS(ts, this.backwards_);
        this.deterministic_ = ltsPersistent.isPersistent();
        if (ltsPersistent.getNode() != null) {
            this.marking_ = (Marking)ltsPersistent.getNode().getExtension(Marking.class.getName());
        }
        this.label1 = ltsPersistent.getLabel1();
        this.label2 = ltsPersistent.getLabel2();
    }

    public boolean isPersistent() {
        return this.deterministic_;
    }

    public Marking getMarking() {
        return this.marking_;
    }

    public String getLabel1() {
        return this.label1;
    }

    public String getLabel2() {
        return this.label2;
    }
}

