/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.persistent;

import uniol.apt.adt.PetriNetOrTransitionSystem;
import uniol.apt.adt.pn.Marking;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.persistent.PersistentNet;
import uniol.apt.analysis.persistent.PersistentTS;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class PersistentModule
extends AbstractModule
implements InterruptibleModule {
    private final boolean backward;

    public PersistentModule(boolean backward) {
        this.backward = backward;
    }

    public PersistentModule() {
        this(false);
    }

    @Override
    public String getName() {
        return this.backward ? "backward_persistent" : "persistent";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn_or_ts", PetriNetOrTransitionSystem.class, "The Petri net or LTS that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("persistent", Boolean.class, "persistent", "success");
        outputSpec.addReturnValue("marking", Marking.class, new String[0]);
        outputSpec.addReturnValue("state", State.class, new String[0]);
        outputSpec.addReturnValue("first_label", String.class, new String[0]);
        outputSpec.addReturnValue("second_label", String.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNetOrTransitionSystem pnOrTs = input.getParameter("pn_or_ts", PetriNetOrTransitionSystem.class);
        PetriNet pn = pnOrTs.getNet();
        TransitionSystem ts = pnOrTs.getTs();
        output.setReturnValue("marking", Marking.class, null);
        output.setReturnValue("state", State.class, null);
        if (pn != null) {
            PersistentNet persistent = new PersistentNet(pn, this.backward);
            persistent.check();
            output.setReturnValue("persistent", Boolean.class, persistent.isPersistent());
            output.setReturnValue("marking", Marking.class, persistent.getMarking());
            output.setReturnValue("first_label", String.class, persistent.getLabel1());
            output.setReturnValue("second_label", String.class, persistent.getLabel2());
        } else {
            PersistentTS persistent = new PersistentTS(ts, this.backward);
            output.setReturnValue("persistent", Boolean.class, persistent.isPersistent());
            output.setReturnValue("state", State.class, persistent.getNode());
            output.setReturnValue("first_label", String.class, persistent.getLabel1());
            output.setReturnValue("second_label", String.class, persistent.getLabel2());
        }
    }

    @Override
    public String getShortDescription() {
        return "Check if a Petri net or LTS is " + (this.backward ? "backward " : "") + "persistent";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ".\n\nA LTS is" + (this.backward ? " backward" : "") + " persistent if for all reachable states s and" + (this.backward ? " backward" : "") + " enabled labels a, b (a\u2260b), there is a state r so that both " + (this.backward ? "r[ab>s and r[ba>s" : "s[ab>r and s[ba>r") + ". A Petri net is" + (this.backward ? " backward" : "") + " persistent if its reachability graph is" + (this.backward ? " backward" : "") + " persistent.";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN, Category.LTS};
    }
}

