/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.mf;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.analysis.mf.MergeFree;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class MergeFreeModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getName() {
        return "mf";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("net", PetriNet.class, "The Petri net that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("mf", Boolean.class, "success");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNet pn = input.getParameter("net", PetriNet.class);
        output.setReturnValue("mf", Boolean.class, new MergeFree().check(pn));
    }

    @Override
    public String getTitle() {
        return "merge-free";
    }

    @Override
    public String getShortDescription() {
        return "Check if a Petri net is merge-free";
    }

    @Override
    public String getLongDescription() {
        return "This module checks if a Petri net is merge-free. A merge is a place where more than one transition produce token.";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

