/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.lts.extension;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.cycles.lts.ComputeSmallestCycles;
import uniol.apt.analysis.persistent.PersistentTS;
import uniol.apt.analysis.reversible.ReversibleTS;

public class ExtendTransitionSystem {
    private final TransitionSystem lts;
    private final BitSet ltsCode;
    private final ArrayList<String> ltsNodes;
    private final ArrayList<String> ltsLabels;
    private List<BitSet> knownMinimalValids;
    private BitSet lastGenerated;
    private boolean lastGeneratedValid;
    private boolean lastGeneratedMinimalValid;

    public ExtendTransitionSystem(TransitionSystem lts, int g) {
        this.lts = lts;
        this.ltsNodes = new ArrayList();
        Iterator<State> it = lts.getNodes().iterator();
        while (it.hasNext()) {
            this.ltsNodes.add(it.next().getId());
        }
        Collections.sort(this.ltsNodes);
        for (int i = 1; i <= g; ++i) {
            String lastID = this.ltsNodes.get(lts.getNodes().size() - 1);
            String newNode = lastID + i;
            this.ltsNodes.add(newNode);
        }
        this.ltsLabels = new ArrayList();
        for (Arc e : lts.getEdges()) {
            if (this.ltsLabels.contains(e.getLabel())) continue;
            this.ltsLabels.add(e.getLabel());
        }
        Collections.sort(this.ltsLabels);
        this.ltsCode = this.generateCode();
        this.knownMinimalValids = new ArrayList<BitSet>();
    }

    public ExtendTransitionSystem(TransitionSystem lts, int g, List<BitSet> minimals) {
        this(lts, g);
        this.knownMinimalValids = minimals;
    }

    public void findNextValid() {
        BitSet code = this.generateCode();
        TransitionSystem lts = this.buildLTS(code);
        while (!this.check(lts) || !this.newNodesReachable(lts)) {
            if ((code = this.nextCode(code)) == null) {
                this.lastGenerated = null;
                this.lastGeneratedValid = false;
                this.lastGeneratedMinimalValid = false;
                return;
            }
            lts = this.buildLTS(code);
        }
        this.lastGenerated = code;
        this.lastGeneratedValid = true;
        this.lastGeneratedMinimalValid = true;
        this.knownMinimalValids.add(code);
    }

    public void findNextValid(BitSet oldCode) {
        BitSet code = this.nextCode(oldCode);
        TransitionSystem lts = this.buildLTS(code);
        while (!this.check(lts) || !this.newNodesReachable(lts)) {
            if ((code = this.nextCode(code)) == null) {
                this.lastGenerated = null;
                this.lastGeneratedValid = false;
                this.lastGeneratedMinimalValid = false;
                return;
            }
            lts = this.buildLTS(code);
        }
        this.lastGenerated = code;
        this.lastGeneratedValid = true;
        this.lastGeneratedMinimalValid = this.noSmallerKnownValid(code);
        if (this.lastGeneratedMinimalValid) {
            this.knownMinimalValids.add(code);
        }
    }

    private boolean newNodesReachable(TransitionSystem lts) {
        for (int i = this.lts.getNodes().size(); i < lts.getNodes().size(); ++i) {
            String id = this.ltsNodes.get(i);
            if (this.reaches(lts.getInitialState(), lts.getNode(id))) continue;
            return false;
        }
        return true;
    }

    private boolean reaches(State start, State goal) {
        HashSet all = new HashSet();
        HashSet<State> now = new HashSet<State>();
        HashSet<State> next = new HashSet<State>();
        if (start.equals(goal)) {
            return true;
        }
        now.add(start);
        next.addAll(start.getPostsetNodes());
        while (next.size() > 0) {
            all.addAll(now);
            now = next;
            next = new HashSet();
            if (now.contains(goal)) {
                return true;
            }
            for (State node : now) {
                Set<State> candidates = node.getPostsetNodes();
                for (State cand : candidates) {
                    if (all.contains(cand) || now.contains(cand)) continue;
                    next.add(cand);
                }
            }
        }
        return false;
    }

    public void findNextMinimal() {
        this.findNextValid();
    }

    public void findNextMinimal(BitSet oldCode) {
        boolean minimal;
        BitSet code = (BitSet)oldCode.clone();
        while (!(minimal = this.noSmallerKnownValid(code = this.nextCode(code))) || !this.check(this.buildLTS(code))) {
        }
        this.lastGenerated = code;
        this.lastGeneratedValid = true;
        this.lastGeneratedMinimalValid = true;
        this.knownMinimalValids.add(code);
    }

    private boolean noSmallerKnownValid(BitSet code) {
        for (BitSet known : this.knownMinimalValids) {
            if (!this.isSubgraph(code, known)) continue;
            return false;
        }
        return true;
    }

    private BitSet generateCode() {
        int n = this.ltsNodes.size();
        int l = this.ltsLabels.size();
        int nl = n * l;
        BitSet code = new BitSet(n * n * l);
        for (Arc e : this.lts.getEdges()) {
            State source = (State)e.getSource();
            State target = (State)e.getTarget();
            String label = e.getLabel();
            int index = this.ltsNodes.indexOf(target.getId()) * nl;
            index += this.ltsLabels.indexOf(label) * n;
            code.set(index += this.ltsNodes.indexOf(source.getId()));
        }
        return code;
    }

    public void findNext() {
        this.findNext(this.ltsCode);
    }

    public void findNext(BitSet oldCode) {
        BitSet code;
        this.lastGenerated = code = this.nextCode(oldCode);
        this.lastGeneratedValid = this.check(this.buildLTS(code));
        this.lastGeneratedMinimalValid = this.noSmallerKnownValid(code);
        if (this.lastGeneratedMinimalValid) {
            this.knownMinimalValids.add(code);
        }
    }

    private BitSet nextCode(BitSet code) {
        boolean done;
        BitSet next = (BitSet)this.ltsCode.clone();
        BitSet diff = (BitSet)code.clone();
        diff.andNot(this.ltsCode);
        int lastFreeBit = code.nextClearBit(0);
        if (lastFreeBit >= this.numberOfPossibleEdges()) {
            return null;
        }
        int additionalEdges = diff.cardinality();
        int lastDiffBit = diff.nextSetBit(0);
        do {
            done = true;
            int nextFreeBit = this.ltsCode.nextClearBit(lastDiffBit + 1);
            if (nextFreeBit >= this.numberOfPossibleEdges() || additionalEdges == 0) {
                ++additionalEdges;
                diff.clear(0, diff.size());
                int last = -1;
                for (int i = 0; i < additionalEdges; ++i) {
                    last = this.ltsCode.nextClearBit(last + 1);
                    diff.set(last);
                }
                diff.or(this.ltsCode);
                return diff;
            }
            if (diff.get(nextFreeBit)) {
                diff.clear(lastDiffBit);
                diff.set(lastFreeBit);
                BitSet nevv = (BitSet)this.ltsCode.clone();
                nevv.or(diff);
                lastFreeBit = nevv.nextClearBit(0);
                done = false;
                lastDiffBit = diff.nextSetBit(lastDiffBit + 1);
                continue;
            }
            diff.clear(lastDiffBit);
            diff.set(nextFreeBit);
            next.or(diff);
        } while (!done);
        return next;
    }

    public TransitionSystem buildLTS(BitSet code) {
        TransitionSystem lts = new TransitionSystem(this.lts);
        BitSet diff = (BitSet)code.clone();
        diff.andNot(this.ltsCode);
        int n = this.ltsNodes.size();
        int l = this.ltsLabels.size();
        int nl = n * l;
        int i = diff.nextSetBit(0);
        while (i > -1) {
            int source = i % n;
            int target = i / nl;
            int label = i % nl / n;
            try {
                lts.getNode(this.ltsNodes.get(source));
            }
            catch (Exception e) {
                lts.createState(this.ltsNodes.get(source));
            }
            try {
                lts.getNode(this.ltsNodes.get(target));
            }
            catch (Exception e) {
                lts.createState(this.ltsNodes.get(target));
            }
            lts.createArc(lts.getNode(this.ltsNodes.get(source)), lts.getNode(this.ltsNodes.get(target)), this.ltsLabels.get(label));
            i = diff.nextSetBit(i + 1);
        }
        return lts;
    }

    private int numberOfPossibleEdges() {
        int n = this.ltsNodes.size();
        int l = this.ltsLabels.size();
        return n * n * l;
    }

    private boolean isSubgraph(BitSet code1, BitSet code2) {
        BitSet diff1 = (BitSet)code1.clone();
        BitSet diff2 = (BitSet)code2.clone();
        diff1.andNot(code2);
        diff2.andNot(code1);
        return diff2.cardinality() == 0;
    }

    private boolean check(TransitionSystem ts) {
        PersistentTS p = new PersistentTS(ts);
        ReversibleTS r = new ReversibleTS(ts);
        ComputeSmallestCycles s = new ComputeSmallestCycles();
        return p.isPersistent() && r.isReversible() && s.checkSamePVs(ts);
    }

    public BitSet getLTSCode() {
        return this.ltsCode;
    }

    public List<BitSet> getListOfMinimals() {
        return this.knownMinimalValids;
    }

    public BitSet getLastGenerated() {
        return this.lastGenerated;
    }

    public boolean isLastGeneratedValid() {
        return this.lastGeneratedValid;
    }

    public boolean isLastGeneratedMinimal() {
        return this.lastGeneratedMinimalValid;
    }
}

