/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.lts.extension;

import java.util.Collection;
import java.util.Set;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.lts.extension.ExtendDeterministicPersistent;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;
import uniol.apt.util.Pair;

public class ExtendDeterministicPersistentModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getName() {
        return "extend_deterministic_persistent";
    }

    @Override
    public String getShortDescription() {
        return "Extend a transition system to an deterministic persistent transition system.";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.LTS};
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("ts", TransitionSystem.class, "The deterministic transition system that should be extended", new String[0]);
        inputSpec.addOptionalParameterWithDefault("rounds", Integer.class, Integer.MAX_VALUE, "unlimited", "Maximum allowed number of processing rounds that add new states", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("needed_arcs", Collection.class, new String[0]);
        outputSpec.addReturnValue("complete", Boolean.class, "success");
        outputSpec.addReturnValue("extended_ts", TransitionSystem.class, "file", "raw");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        int maxRounds;
        TransitionSystem ts = input.getParameter("ts", TransitionSystem.class);
        Collection<Set<Pair<State, String>>> neededArcs = new ExtendDeterministicPersistent().extendTs(ts, maxRounds = input.getParameter("rounds", Integer.class).intValue());
        if (!neededArcs.isEmpty()) {
            output.setReturnValue("needed_arcs", Collection.class, neededArcs);
        }
        output.setReturnValue("complete", Boolean.class, neededArcs.isEmpty());
        output.setReturnValue("extended_ts", TransitionSystem.class, ts);
    }
}

