/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.lts.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uniol.apt.adt.Edge;
import uniol.apt.adt.exception.ArcExistsException;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.ParikhVector;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.deterministic.Deterministic;
import uniol.apt.analysis.exception.MustLeadToSameStateException;
import uniol.apt.analysis.exception.NoFiniteExtensionPossibleException;
import uniol.apt.analysis.exception.NonDeterministicException;
import uniol.apt.util.DebugUtil;
import uniol.apt.util.DifferentPairsIterable;
import uniol.apt.util.EquivalenceRelation;
import uniol.apt.util.Pair;
import uniol.apt.util.SpanningTree;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class ExtendDeterministicPersistent {
    private static List<String> arcListToEventList(List<Arc> arcs) {
        ArrayList<String> events = new ArrayList<String>();
        for (Arc arc : arcs) {
            events.add(arc.getLabel());
        }
        return events;
    }

    private static List<String> residual(List<String> p, List<String> q) {
        ParikhVector qPV = new ParikhVector(q);
        ArrayList<String> res = new ArrayList<String>();
        for (String event : p) {
            ParikhVector newPV = qPV.tryRemove(event, 1);
            if (newPV == null) {
                res.add(event);
                continue;
            }
            qPV = newPV;
        }
        return res;
    }

    public Collection<Set<Pair<State, String>>> extendTs(TransitionSystem ts, int maxPhase2Rounds) throws NoFiniteExtensionPossibleException, NonDeterministicException, MustLeadToSameStateException {
        Collection<Set<Pair<State, String>>> eqRel;
        new Deterministic(ts).throwIfNonDeterministic();
        int rounds = 0;
        int phase2Ctr = 0;
        while (true) {
            DebugUtil.debugFormat("Starting round %d", rounds++);
            eqRel = this.findNeededArcs(ts.getNodes());
            if (eqRel.isEmpty()) break;
            Pair<Collection<Set<Pair<State, String>>>, Boolean> phase1Pair = this.completeDiamonds(ts, eqRel);
            if (phase1Pair.getSecond().booleanValue()) continue;
            eqRel = phase1Pair.getFirst();
            if (eqRel.isEmpty() || ++phase2Ctr > maxPhase2Rounds) break;
            Map<State, Set<String>> uncompletableStates = this.checkFiniteCompletionPossible(ts);
            for (Set<Pair<State, String>> arcSet : eqRel) {
                for (Pair<State, String> neededArc : arcSet) {
                    if (!uncompletableStates.containsKey(neededArc.getFirst()) || !uncompletableStates.get(neededArc.getFirst()).contains(neededArc.getSecond())) continue;
                    throw new NoFiniteExtensionPossibleException(neededArc.getFirst());
                }
            }
            this.constructDiamonds(ts, eqRel);
        }
        return eqRel;
    }

    private Map<State, Set<String>> checkFiniteCompletionPossible(TransitionSystem ts) {
        HashMap<State, Set<String>> uncompletableStates = new HashMap<State, Set<String>>();
        SpanningTree st = SpanningTree.get(ts);
        for (Arc chord : st.getChords()) {
            ArrayList<Arc> sourcePath = new ArrayList<Arc>(st.getEdgePathFromStart(chord.getSource()));
            sourcePath.add(chord);
            List<Arc> targetPath = st.getEdgePathFromStart(chord.getTarget());
            List<String> sourceSeq = ExtendDeterministicPersistent.arcListToEventList(sourcePath);
            List<String> targetSeq = ExtendDeterministicPersistent.arcListToEventList(targetPath);
            List<String> sourceResidual = ExtendDeterministicPersistent.residual(sourceSeq, targetSeq);
            List<String> targetResidual = ExtendDeterministicPersistent.residual(targetSeq, sourceSeq);
            if (sourceResidual.isEmpty() || targetResidual.isEmpty()) continue;
            HashSet<String> uncompletableEvents = (HashSet<String>)uncompletableStates.get(chord.getTarget());
            if (uncompletableEvents == null) {
                uncompletableEvents = new HashSet<String>();
                uncompletableStates.put((State)chord.getTarget(), (Set<String>)uncompletableEvents);
            }
            uncompletableEvents.add(sourceResidual.get(0));
            uncompletableEvents.add(targetResidual.get(0));
        }
        return uncompletableStates;
    }

    private Collection<Set<Pair<State, String>>> findNeededArcs(Iterable<State> states) {
        EquivalenceRelation<Pair<State, String>> ret = new EquivalenceRelation<Pair<State, String>>();
        for (State state : states) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            Map<String, State> postset = this.getStatePostset(state);
            Set<String> labels = postset.keySet();
            for (Pair<String, String> pair : new DifferentPairsIterable<String>(labels)) {
                String label1 = pair.getFirst();
                String label2 = pair.getSecond();
                State state1 = postset.get(label1);
                State state2 = postset.get(label2);
                ret.joinClasses(new NeededArc(state2, label1), new NeededArc(state1, label2));
            }
        }
        return ret;
    }

    private Pair<Collection<Set<Pair<State, String>>>, Boolean> completeDiamonds(TransitionSystem ts, Collection<Set<Pair<State, String>>> eqClasses) throws MustLeadToSameStateException {
        ArrayList<Set<Pair<State, String>>> unsolvedClasses = new ArrayList<Set<Pair<State, String>>>();
        boolean modified = false;
        for (Set<Pair<State, String>> eqClass : eqClasses) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            Edge succ = null;
            Pair<State, String> succArc = null;
            for (Pair<State, String> arcPair : eqClass) {
                Arc curSucc = this.getArc(arcPair.getFirst(), arcPair.getSecond());
                if (curSucc == null) continue;
                if (succ == null) {
                    succ = curSucc;
                    succArc = arcPair;
                    continue;
                }
                if (((State)succ.getTarget()).equals(curSucc.getTarget())) continue;
                throw new MustLeadToSameStateException((Arc)succ, curSucc);
            }
            if (succ != null) {
                modified |= this.mapEqClass(ts, eqClass, (State)succ.getTarget());
                continue;
            }
            unsolvedClasses.add(eqClass);
        }
        return new Pair<Collection<Set<Pair<State, String>>>, Boolean>(unsolvedClasses, modified);
    }

    private void constructDiamonds(TransitionSystem ts, Collection<Set<Pair<State, String>>> unsolvedClasses) {
        for (Set<Pair<State, String>> eqClass : unsolvedClasses) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            State succ = ts.createState();
            this.mapEqClass(ts, eqClass, succ);
            DebugUtil.debugFormat("Added new State %s as target of %s.", eqClass, succ);
        }
    }

    private boolean mapEqClass(TransitionSystem ts, Set<Pair<State, String>> eqClass, State state) {
        boolean modified = false;
        for (Pair<State, String> arcPair : eqClass) {
            try {
                ts.createArc(arcPair.getFirst(), state, arcPair.getSecond());
                modified = true;
            }
            catch (ArcExistsException arcExistsException) {}
        }
        return modified;
    }

    private Map<String, State> getStatePostset(State node) {
        HashMap<String, State> result = new HashMap();
        for (Arc arc : node.getPostsetEdges()) {
            State old = (State)result.put(arc.getLabel(), (State)arc.getTarget());
            assert (old == null);
        }
        result = Collections.unmodifiableMap(result);
        return result;
    }

    private Arc getArc(State node, String label) {
        for (Arc arc : node.getPostsetEdges()) {
            if (!label.equals(arc.getLabel())) continue;
            return arc;
        }
        return null;
    }

    private static class NeededArc
    extends Pair<State, String> {
        private NeededArc(State state, String label) {
            super(state, label);
        }

        @Override
        public String toString() {
            return String.format("%s--%s->", ((State)this.getFirst()).getId(), this.getSecond());
        }
    }
}

