/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.live;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Transition;
import uniol.apt.analysis.live.AbstractLiveModule;
import uniol.apt.analysis.live.Live;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class WeaklyLiveModule
extends AbstractLiveModule
implements InterruptibleModule {
    @Override
    public String getShortDescription() {
        return "Check if a Petri net or a transition (if given) is weakly live";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ". A transition is weakly live if an infinite fire sequence exists which fires this transition infinitely often. A Petri net is weakly live when all of its transitions are weakly live";
    }

    @Override
    public String getName() {
        return "weakly_live";
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("weakly_live", Boolean.class, "success");
        outputSpec.addReturnValue("sample_witness_transition", Transition.class, new String[0]);
    }

    @Override
    protected void findNonLiveTransition(ModuleOutput output, PetriNet pn) throws ModuleException {
        Transition trans = Live.findNonWeaklyLiveTransition(pn);
        output.setReturnValue("weakly_live", Boolean.class, trans == null);
        output.setReturnValue("sample_witness_transition", Transition.class, trans);
    }

    @Override
    protected void checkTransitionLiveness(ModuleOutput output, PetriNet pn, Transition transition) throws ModuleException {
        boolean live = Live.checkWeaklyLive(pn, transition);
        output.setReturnValue("weakly_live", Boolean.class, live);
    }
}

