/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.live;

import java.util.Collection;
import java.util.List;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Transition;
import uniol.apt.analysis.language.FiringSequence;
import uniol.apt.analysis.live.AbstractLiveModule;
import uniol.apt.analysis.live.Live;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class StronglyLiveModule
extends AbstractLiveModule
implements InterruptibleModule {
    @Override
    public String getShortDescription() {
        return "Check if a Petri net or a transition (if given) is strongly live";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ". A transition is strongly live when for every reachable marking there exists a firing sequence after which this transition is activated. A Petri net is strongly live when all of its transitions are strongly live. For a transition which is not strongly live, this module finds a firing sequence after which the transition cannot fire anymore.";
    }

    @Override
    public String getName() {
        return "strongly_live";
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("strongly_live", Boolean.class, "success");
        outputSpec.addReturnValue("sample_witness_transition", Transition.class, new String[0]);
        outputSpec.addReturnValue("sample_witness_firing_sequence", FiringSequence.class, new String[0]);
    }

    @Override
    protected void findNonLiveTransition(ModuleOutput output, PetriNet pn) throws ModuleException {
        Transition trans = Live.findNonStronglyLiveTransition(pn);
        output.setReturnValue("strongly_live", Boolean.class, trans == null);
        output.setReturnValue("sample_witness_transition", Transition.class, trans);
        if (trans != null) {
            output.setReturnValue("sample_witness_firing_sequence", FiringSequence.class, new FiringSequence((Collection<Transition>)Live.findKillingFireSequence(pn, trans)));
        }
    }

    @Override
    protected void checkTransitionLiveness(ModuleOutput output, PetriNet pn, Transition transition) throws ModuleException {
        List<Transition> killingSequence = Live.findKillingFireSequence(pn, transition);
        output.setReturnValue("strongly_live", Boolean.class, killingSequence == null);
        if (killingSequence != null) {
            output.setReturnValue("sample_witness_firing_sequence", FiringSequence.class, new FiringSequence((Collection<Transition>)killingSequence));
        }
    }
}

