/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.live;

import java.util.Collection;
import java.util.List;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Transition;
import uniol.apt.analysis.language.FiringSequence;
import uniol.apt.analysis.live.AbstractLiveModule;
import uniol.apt.analysis.live.Live;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class SimplyLiveModule
extends AbstractLiveModule
implements InterruptibleModule {
    @Override
    public String getShortDescription() {
        return "Check if a Petri net or a transition (if given) is simply live";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ". A transition is simply live when it can fire at least once. A Petri net is simply live when all of its transitions are simply live. For a simply live transition, this module finds a firing sequence that fires the transition.";
    }

    @Override
    public String getName() {
        return "simply_live";
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("simply_live", Boolean.class, "success");
        outputSpec.addReturnValue("sample_dead_transition", Transition.class, new String[0]);
        outputSpec.addReturnValue("sample_witness_firing_sequence", FiringSequence.class, new String[0]);
    }

    @Override
    protected void findNonLiveTransition(ModuleOutput output, PetriNet pn) throws ModuleException {
        Transition dead = Live.findDeadTransition(pn);
        output.setReturnValue("simply_live", Boolean.class, dead == null);
        output.setReturnValue("sample_dead_transition", Transition.class, dead);
    }

    @Override
    protected void checkTransitionLiveness(ModuleOutput output, PetriNet pn, Transition transition) throws ModuleException {
        List<Transition> live = Live.checkSimplyLive(pn, transition);
        output.setReturnValue("simply_live", Boolean.class, live != null);
        if (live != null) {
            output.setReturnValue("sample_witness_firing_sequence", FiringSequence.class, new FiringSequence((Collection<Transition>)live));
        }
    }
}

