/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.live;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Transition;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.connectivity.Connectivity;
import uniol.apt.analysis.coverability.CoverabilityGraph;
import uniol.apt.analysis.coverability.CoverabilityGraphEdge;
import uniol.apt.analysis.coverability.CoverabilityGraphNode;
import uniol.apt.analysis.exception.UnboundedException;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class Live {
    private Live() {
    }

    public static Transition findDeadTransition(PetriNet pn) throws UnboundedException {
        for (Transition t : pn.getTransitions()) {
            if (Live.checkSimplyLive(pn, t) != null) continue;
            return t;
        }
        return null;
    }

    public static List<Transition> checkSimplyLive(PetriNet pn, Transition transition) {
        for (CoverabilityGraphEdge arc : CoverabilityGraph.get(pn).getEdges()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            Transition trans = arc.getTransition();
            if (!trans.equals(transition)) continue;
            CoverabilityGraphNode source = arc.getSource();
            ArrayList<Transition> result = new ArrayList<Transition>(source.getFiringSequence());
            result.add(transition);
            return result;
        }
        return null;
    }

    public static Transition findNonWeaklyLiveTransition(PetriNet pn) throws UnboundedException {
        TransitionSystem lts = CoverabilityGraph.get(pn).toReachabilityLTS();
        Set components = Connectivity.getStronglyConnectedComponents(lts);
        for (Transition t : pn.getTransitions()) {
            if (Live.checkWeaklyLive(lts, components, t)) continue;
            return t;
        }
        return null;
    }

    public static boolean checkWeaklyLive(PetriNet pn, Transition transition) throws UnboundedException {
        TransitionSystem lts = CoverabilityGraph.get(pn).toReachabilityLTS();
        Set components = Connectivity.getStronglyConnectedComponents(lts);
        return Live.checkWeaklyLive(lts, components, transition);
    }

    private static boolean checkWeaklyLive(TransitionSystem lts, Set<? extends Set<State>> components, Transition transition) {
        block0: for (Arc edge : lts.getEdges()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            Transition trans = (Transition)edge.getExtension(Transition.class.getName());
            if (!trans.equals(transition)) continue;
            State source = (State)edge.getSource();
            State target = (State)edge.getTarget();
            for (Set<State> set : components) {
                if (!set.contains(source)) continue;
                if (!set.contains(target)) continue block0;
                return true;
            }
        }
        return false;
    }

    public static Transition findNonStronglyLiveTransition(PetriNet pn) throws UnboundedException {
        for (Transition t : pn.getTransitions()) {
            if (Live.checkStronglyLive(pn, t)) continue;
            return t;
        }
        return null;
    }

    public static boolean checkStronglyLive(PetriNet pn, Transition transition) throws UnboundedException {
        return Live.findKillingFireSequence(pn, transition) == null;
    }

    public static List<Transition> findKillingFireSequence(PetriNet pn, Transition transition) throws UnboundedException {
        TransitionSystem lts = CoverabilityGraph.get(pn).toReachabilityLTS();
        HashSet<State> nodes = new HashSet<State>(lts.getNodes());
        for (Arc edge : lts.getEdges()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            Transition trans = (Transition)edge.getExtension(Transition.class.getName());
            if (!trans.equals(transition)) continue;
            Live.handleStronglyLiveNode(nodes, (State)edge.getSource());
        }
        if (nodes.isEmpty()) {
            return null;
        }
        State node = (State)nodes.iterator().next();
        return ((CoverabilityGraphNode)node.getExtension(CoverabilityGraphNode.class.getName())).getFiringSequence();
    }

    private static void handleStronglyLiveNode(Collection<State> nodes, State node) {
        ArrayDeque<State> toRemove = new ArrayDeque<State>();
        toRemove.add(node);
        while (!toRemove.isEmpty()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            node = (State)toRemove.remove();
            if (!nodes.remove(node)) continue;
            toRemove.addAll(node.getPresetNodes());
        }
    }
}

