/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.live;

import uniol.apt.adt.exception.NoSuchNodeException;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Transition;
import uniol.apt.analysis.exception.NoSuchTransitionException;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.exception.ModuleException;

public abstract class AbstractLiveModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public final void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn", PetriNet.class, "The Petri net that should be examined", new String[0]);
        inputSpec.addOptionalParameterWithoutDefault("transition", String.class, "A transition that should be checked for liveness", new String[0]);
    }

    protected abstract void findNonLiveTransition(ModuleOutput var1, PetriNet var2) throws ModuleException;

    protected abstract void checkTransitionLiveness(ModuleOutput var1, PetriNet var2, Transition var3) throws ModuleException;

    @Override
    public final void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNet pn = input.getParameter("pn", PetriNet.class);
        String id = input.getParameter("transition", String.class);
        if (id == null) {
            this.findNonLiveTransition(output, pn);
        } else {
            Transition transition;
            try {
                transition = pn.getTransition(id);
            }
            catch (NoSuchNodeException e) {
                throw new NoSuchTransitionException(pn, e);
            }
            this.checkTransitionLiveness(output, pn, transition);
        }
    }

    @Override
    public final Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

