/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.language;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.analysis.language.FiringSequence;
import uniol.apt.analysis.language.Word;
import uniol.apt.analysis.language.WordInLanguage;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class WordInLanguageModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getShortDescription() {
        return "Check if a word is in a Petri net's prefix language";
    }

    @Override
    public String getName() {
        return "word";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn", PetriNet.class, "The Petri net that should be examined", new String[0]);
        inputSpec.addParameter("word", Word.class, "The word which should be checked", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("in_language", Boolean.class, "success");
        outputSpec.addReturnValue("firing_sequence", FiringSequence.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        Word word;
        PetriNet pn = input.getParameter("pn", PetriNet.class);
        WordInLanguage test = new WordInLanguage(pn);
        FiringSequence result = test.checkWord(word = input.getParameter("word", Word.class));
        output.setReturnValue("in_language", Boolean.class, result != null);
        if (result != null) {
            output.setReturnValue("firing_sequence", FiringSequence.class, result);
        }
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

