/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.language;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uniol.apt.adt.pn.Marking;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Transition;
import uniol.apt.analysis.language.FiringSequence;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class WordInLanguage {
    private final PetriNet pn;

    public WordInLanguage(PetriNet pn) {
        this.pn = pn;
    }

    Map<String, Set<Transition>> getLabels() {
        HashMap<String, Set<Transition>> result = new HashMap<String, Set<Transition>>();
        for (Transition trans : this.pn.getTransitions()) {
            HashSet<Transition> set = (HashSet<Transition>)result.get(trans.getLabel());
            if (set == null) {
                set = new HashSet<Transition>();
                result.put(trans.getLabel(), set);
            }
            set.add(trans);
        }
        return result;
    }

    public FiringSequence checkWord(List<String> word) {
        return this.checkWord(this.pn.getInitialMarking(), word, 0, this.getLabels());
    }

    FiringSequence checkWord(Marking curMarking, List<String> word, int idx, Map<String, Set<Transition>> labels) {
        if (idx == word.size()) {
            return new FiringSequence();
        }
        Set<Transition> transitions = labels.get(word.get(idx));
        if (transitions == null) {
            return null;
        }
        for (Transition trans : transitions) {
            Marking newMarking;
            FiringSequence result;
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            if (!trans.isFireable(curMarking) || (result = this.checkWord(newMarking = trans.fire(curMarking), word, idx + 1, labels)) == null) continue;
            result.add(0, trans);
            return result;
        }
        return null;
    }
}

