/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.language;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import uniol.apt.adt.PetriNetOrTransitionSystem;
import uniol.apt.adt.automaton.AutomatonToRegularExpression;
import uniol.apt.adt.automaton.FiniteAutomatonUtility;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.connectivity.Connectivity;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class ToRegularExpressionModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getShortDescription() {
        return "Create a language-equivalent (up to prefix creation) regular expression";
    }

    @Override
    public String getName() {
        return "to_regular_expression";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn_or_ts", PetriNetOrTransitionSystem.class, "A Petri net or transition system whose language should be used", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("regular_expression", String.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNetOrTransitionSystem arg = input.getParameter("pn_or_ts", PetriNetOrTransitionSystem.class);
        TransitionSystem ts = arg.getReachabilityLTS();
        output.setReturnValue("regular_expression", String.class, ToRegularExpressionModule.toRegularExpression(ts));
    }

    private static Set<State> chooseFinalNodes(TransitionSystem ts) {
        Set components = Connectivity.getStronglyConnectedComponents(ts);
        Iterator it = components.iterator();
        while (it.hasNext()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            Set component = it.next();
            boolean skip = false;
            for (State node : component) {
                for (State following : node.getPostsetNodes()) {
                    if (component.contains(following)) continue;
                    skip = true;
                    break;
                }
                if (!skip) continue;
                break;
            }
            if (!skip) continue;
            it.remove();
        }
        HashSet<State> result = new HashSet<State>();
        for (Set component : components) {
            result.add(ts.getNode(((State)component.iterator().next()).getId()));
        }
        return result;
    }

    private static String toRegularExpression(TransitionSystem ts) {
        Set<State> finalStates = ToRegularExpressionModule.chooseFinalNodes(ts);
        return "@(" + AutomatonToRegularExpression.automatonToRegularExpression(FiniteAutomatonUtility.fromLTS(ts, finalStates)) + ")";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN, Category.LTS};
    }
}

