/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.language;

import uniol.apt.adt.PetriNetOrTransitionSystem;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.language.LanguageEquivalence;
import uniol.apt.analysis.language.Word;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class LanguageEquivalenceModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getShortDescription() {
        return "Check if two Petri nets generate the same language";
    }

    @Override
    public String getName() {
        return "language_equivalence";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn_or_ts1", PetriNetOrTransitionSystem.class, "The first Petri net or transition system that should be examined", new String[0]);
        inputSpec.addParameter("pn_or_ts2", PetriNetOrTransitionSystem.class, "The second Petri net or transition system that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("language_equivalent", Boolean.class, "success");
        outputSpec.addReturnValue("witness_word", Word.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNetOrTransitionSystem arg1 = input.getParameter("pn_or_ts1", PetriNetOrTransitionSystem.class);
        PetriNetOrTransitionSystem arg2 = input.getParameter("pn_or_ts2", PetriNetOrTransitionSystem.class);
        TransitionSystem lts1 = arg1.getReachabilityLTS();
        TransitionSystem lts2 = arg2.getReachabilityLTS();
        Word word = LanguageEquivalence.checkLanguageEquivalence(lts1, lts2);
        output.setReturnValue("witness_word", Word.class, word);
        output.setReturnValue("language_equivalent", Boolean.class, word == null);
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN, Category.LTS};
    }
}

