/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.isomorphism;

import uniol.apt.adt.PetriNetOrTransitionSystem;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.isomorphism.Isomorphism;
import uniol.apt.analysis.isomorphism.IsomorphismLogic;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class IsomorphismModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getShortDescription() {
        return "Check if two Petri nets have isomorphic reachability graphs";
    }

    @Override
    public String getName() {
        return "isomorphism";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn_or_ts1", PetriNetOrTransitionSystem.class, "The first Petri net or transition system that should be examined", new String[0]);
        inputSpec.addParameter("pn_or_ts2", PetriNetOrTransitionSystem.class, "The second Petri net or transition system that should be examined", new String[0]);
        inputSpec.addOptionalParameterWithoutDefault("dontCheckLabels", String.class, "do not check arc labels (default is to check labels)", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("isomorphic_reachability_graphs", Boolean.class, "success");
        outputSpec.addReturnValue("isomorphism", Isomorphism.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNetOrTransitionSystem arg1 = input.getParameter("pn_or_ts1", PetriNetOrTransitionSystem.class);
        PetriNetOrTransitionSystem arg2 = input.getParameter("pn_or_ts2", PetriNetOrTransitionSystem.class);
        TransitionSystem lts1 = arg1.getReachabilityLTS();
        TransitionSystem lts2 = arg2.getReachabilityLTS();
        boolean checkLabels = true;
        if (input.getParameter("dontCheckLabels", String.class) != null) {
            checkLabels = false;
        }
        IsomorphismLogic logic = new IsomorphismLogic(lts1, lts2, checkLabels);
        boolean result = logic.isIsomorphic();
        output.setReturnValue("isomorphic_reachability_graphs", Boolean.class, result);
        if (result) {
            output.setReturnValue("isomorphism", Isomorphism.class, new Isomorphism(logic.getIsomorphism()));
        }
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN, Category.LTS};
    }
}

