/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.isomorphism;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.collections4.bidimap.UnmodifiableBidiMap;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.util.Pair;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class IsomorphismLogicComplex {
    private Deque<ExtendedState> finalState = new LinkedList<ExtendedState>();
    private final BidiMap<State, State> isomorphism = new DualHashBidiMap<State, State>();
    private final int numNodes;
    private final TransitionSystem graph1;
    private final TransitionSystem graph2;
    private final List<State> nodes1List = new ArrayList<State>();
    private final List<State> nodes2List = new ArrayList<State>();
    private final Map<State, State> core1 = new HashMap<State, State>();
    private final Map<State, State> core2 = new HashMap<State, State>();
    private final Map<State, Integer> in1 = new HashMap<State, Integer>();
    private final Map<State, Integer> in2 = new HashMap<State, Integer>();
    private final Map<State, Integer> out1 = new HashMap<State, Integer>();
    private final Map<State, Integer> out2 = new HashMap<State, Integer>();
    private final boolean result;
    private final boolean checkLabels;

    public IsomorphismLogicComplex(TransitionSystem lts1, TransitionSystem lts2, boolean checkLabels) {
        this.checkLabels = checkLabels;
        this.graph1 = lts1;
        this.graph2 = lts2;
        this.numNodes = lts1.getNodes().size();
        if (lts1.getNodes().size() != lts2.getNodes().size()) {
            this.result = false;
            return;
        }
        this.nodes1List.add(lts1.getInitialState());
        for (State n : lts1.getNodes()) {
            if (n.equals(lts1.getInitialState())) continue;
            this.nodes1List.add(n);
        }
        this.nodes2List.add(lts2.getInitialState());
        for (State n : lts2.getNodes()) {
            if (n.equals(lts2.getInitialState())) continue;
            this.nodes2List.add(n);
        }
        this.result = this.doMatch(new ExtendedState());
    }

    public boolean isIsomorphic() {
        return this.result;
    }

    private boolean doMatch(ExtendedState state) {
        LinkedList<ExtendedState> states = new LinkedList<ExtendedState>();
        states.addLast(state);
        int depth = 0;
        while (!states.isEmpty()) {
            ExtendedState s = (ExtendedState)states.getLast();
            depth = s.depth;
            if (depth > 0) {
                this.core1.put(s.n, s.m);
                this.core2.put(s.m, s.n);
            }
            if (depth == this.numNodes) break;
            if (!s.active) {
                this.computeTerminalSets(depth, s);
            }
            Pair<State, State> node = this.computeP(depth, s);
            boolean goodState = false;
            s.active = true;
            while (node != null) {
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                State n = node.getFirst();
                State m = node.getSecond();
                if (this.isFeasible(n, m)) {
                    goodState = true;
                    ExtendedState news = new ExtendedState(s, depth + 1, n, m);
                    if (!this.in1.containsKey(n)) {
                        this.in1.put(n, depth + 1);
                        ++news.numin1;
                    }
                    if (!this.out1.containsKey(n)) {
                        this.out1.put(n, depth + 1);
                        ++news.numout1;
                    }
                    if (!this.in2.containsKey(m)) {
                        this.in2.put(m, depth + 1);
                        ++news.numin2;
                    }
                    if (!this.out2.containsKey(m)) {
                        this.out2.put(m, depth + 1);
                        ++news.numout2;
                    }
                    states.addLast(news);
                    break;
                }
                node = this.computeP(depth, s);
            }
            if (goodState) continue;
            this.rollback(depth, s.n, s.m);
            ExtendedState last = (ExtendedState)states.removeLast();
            assert (last == s);
        }
        this.finalState = states;
        for (ExtendedState ext : states) {
            if (ext.depth <= 0) continue;
            this.isomorphism.put(ext.n, ext.m);
        }
        return depth == this.numNodes;
    }

    private void rollback(int depth, State nodeN, State nodeM) {
        State old = this.core1.remove(nodeN);
        assert (depth == 0 || old != null);
        old = this.core2.remove(nodeM);
        assert (depth == 0 || old != null);
        for (State n : this.nodes1List) {
            if (this.in1.containsKey(n) && this.in1.get(n) == depth) {
                this.in1.remove(n);
            }
            if (!this.out1.containsKey(n) || this.out1.get(n) != depth) continue;
            this.out1.remove(n);
        }
        for (State m : this.nodes2List) {
            if (this.in2.containsKey(m) && this.in2.get(m) == depth) {
                this.in2.remove(m);
            }
            if (!this.out2.containsKey(m) || this.out2.get(m) != depth) continue;
            this.out2.remove(m);
        }
    }

    private boolean isFeasible(State nodeN, State nodeM) {
        int tin1 = 0;
        int tin2 = 0;
        int tout1 = 0;
        int tout2 = 0;
        int new1 = 0;
        int new2 = 0;
        if (this.graph1.getInitialState() == nodeN != (this.graph2.getInitialState() == nodeM)) {
            return false;
        }
        for (Arc inN : nodeN.getPresetEdges()) {
            if (this.core1.containsKey(inN.getSource())) {
                if (this.checkMatchingArc(this.core1.get(inN.getSource()), nodeM, inN.getLabel())) continue;
                return false;
            }
            if (this.in1.containsKey(inN.getSource())) {
                ++tin1;
            }
            if (this.out1.containsKey(inN.getSource())) {
                ++tout1;
            }
            if (this.in1.containsKey(inN.getSource()) || this.out1.containsKey(inN.getSource())) continue;
            ++new1;
        }
        for (Arc outN : nodeN.getPostsetEdges()) {
            if (this.core1.containsKey(outN.getTarget())) {
                if (this.checkMatchingArc(nodeM, this.core1.get(outN.getTarget()), outN.getLabel())) continue;
                return false;
            }
            if (this.in1.containsKey(outN.getTarget())) {
                ++tin1;
            }
            if (this.out1.containsKey(outN.getTarget())) {
                ++tout1;
            }
            if (this.in1.containsKey(outN.getTarget()) || this.out1.containsKey(outN.getTarget())) continue;
            ++new1;
        }
        for (Arc inM : nodeM.getPresetEdges()) {
            if (this.core2.containsKey(inM.getSource())) {
                if (this.checkMatchingArc(this.core2.get(inM.getSource()), nodeN, inM.getLabel())) continue;
                return false;
            }
            if (this.in2.containsKey(inM.getSource())) {
                ++tin2;
            }
            if (this.out2.containsKey(inM.getSource())) {
                ++tout2;
            }
            if (this.in2.containsKey(inM.getSource()) || this.out2.containsKey(inM.getSource())) continue;
            ++new2;
        }
        for (Arc outM : nodeM.getPostsetEdges()) {
            if (this.core2.containsKey(outM.getTarget())) {
                if (this.checkMatchingArc(nodeN, this.core2.get(outM.getTarget()), outM.getLabel())) continue;
                return false;
            }
            if (this.in2.containsKey(outM.getTarget())) {
                ++tin2;
            }
            if (this.out2.containsKey(outM.getTarget())) {
                ++tout2;
            }
            if (this.in2.containsKey(outM.getTarget()) || this.out2.containsKey(outM.getTarget())) continue;
            ++new2;
        }
        return tin1 == tin2 && tout1 == tout2 && new1 == new2;
    }

    private Pair<State, State> computeP(int depth, ExtendedState s) {
        block13: {
            State nodeId;
            block14: {
                block12: {
                    nodeId = null;
                    if (s.numout1 <= depth || s.numout2 <= depth) break block12;
                    if (s.mint2out == null) {
                        for (State i : this.nodes2List) {
                            if (!this.out2.containsKey(i) || this.core2.containsKey(i)) continue;
                            nodeId = i;
                            break;
                        }
                        if (nodeId == null) {
                            return null;
                        }
                        s.mint2out = nodeId;
                    }
                    while (s.curnode < this.numNodes) {
                        ++s.curnode;
                        if (!this.out1.containsKey(this.nodes1List.get(s.curnode - 1)) || this.core1.containsKey(this.nodes1List.get(s.curnode - 1))) continue;
                        return new Pair<State, State>(this.nodes1List.get(s.curnode - 1), s.mint2out);
                    }
                    break block13;
                }
                if (s.numout1 > depth || s.numout2 > depth || s.numin1 <= depth || s.numin2 <= depth) break block14;
                if (s.mint2in == null) {
                    for (State i : this.nodes2List) {
                        if (this.in2.containsKey(i) || this.core2.containsKey(i)) continue;
                        nodeId = i;
                        break;
                    }
                    if (nodeId == null) {
                        return null;
                    }
                    s.mint2in = nodeId;
                }
                while (s.curnode < this.numNodes) {
                    ++s.curnode;
                    if (!this.in1.containsKey(this.nodes1List.get(s.curnode - 1)) || this.core1.containsKey(this.nodes1List.get(s.curnode - 1))) continue;
                    return new Pair<State, State>(this.nodes1List.get(s.curnode - 1), s.mint2in);
                }
                break block13;
            }
            if (s.numout1 != depth || s.numout2 != depth || s.numin1 != depth || s.numin2 != depth) break block13;
            if (s.minn2m2 == null) {
                for (State n2 : this.nodes2List) {
                    if (this.core2.containsKey(n2)) continue;
                    nodeId = n2;
                    break;
                }
                if (nodeId == null) {
                    return null;
                }
                s.minn2m2 = nodeId;
            }
            while (s.curnode < this.numNodes) {
                ++s.curnode;
                if (this.core1.containsKey(this.nodes1List.get(s.curnode - 1))) continue;
                return new Pair<State, State>(this.nodes1List.get(s.curnode - 1), s.minn2m2);
            }
        }
        return null;
    }

    private void computeTerminalSets(int depth, ExtendedState s) {
        for (State src : this.nodes1List) {
            if (!this.core1.containsKey(src)) continue;
            for (State postNode : src.getPostsetNodes()) {
                if (this.out1.containsKey(postNode) || this.core1.containsKey(postNode)) continue;
                this.out1.put(postNode, depth);
                ++s.numout1;
            }
            for (State preNode : src.getPresetNodes()) {
                if (this.in1.containsKey(preNode) || this.core1.containsKey(preNode)) continue;
                this.in1.put(preNode, depth);
                ++s.numin1;
            }
        }
        for (State src : this.nodes2List) {
            if (!this.core2.containsKey(src)) continue;
            for (State postNode : src.getPostsetNodes()) {
                if (this.out2.containsKey(postNode) || this.core2.containsKey(postNode)) continue;
                this.out2.put(postNode, depth);
                ++s.numout2;
            }
            for (State preNode : src.getPresetNodes()) {
                if (this.in2.containsKey(preNode) || this.core2.containsKey(preNode)) continue;
                this.in2.put(preNode, depth);
                ++s.numin2;
            }
        }
    }

    private boolean checkMatchingArc(State source, State target, String label) {
        for (Arc arc : source.getPostsetEdges()) {
            if (arc.getTarget() != target || this.checkLabels && !arc.getLabel().equals(label)) continue;
            return true;
        }
        return false;
    }

    public Deque<ExtendedState> getFinalState() {
        return this.finalState;
    }

    public BidiMap<State, State> getIsomorphism() {
        return UnmodifiableBidiMap.unmodifiableBidiMap(this.isomorphism);
    }

    public static class ExtendedState {
        int numin1;
        int numin2;
        int numout1;
        int numout2;
        int curnode;
        int depth;
        private State n;
        State m;
        State mint2out;
        State mint2in;
        State minn2m2;
        boolean active;

        ExtendedState() {
            this.active = false;
        }

        ExtendedState(ExtendedState s, int d, State newN, State newM) {
            this.numin1 = s.numin1;
            this.numin2 = s.numin2;
            this.numout1 = s.numout1;
            this.numout2 = s.numout2;
            this.curnode = 0;
            this.depth = d;
            this.n = newN;
            this.m = newM;
            this.active = false;
        }

        public State getN() {
            return this.n;
        }

        public State getM() {
            return this.m;
        }
    }
}

