/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.isomorphism;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.collections4.bidimap.UnmodifiableBidiMap;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.deterministic.Deterministic;
import uniol.apt.analysis.isomorphism.IsomorphismLogicComplex;
import uniol.apt.analysis.totallyreachable.TotallyReachable;
import uniol.apt.util.Pair;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class IsomorphismLogic {
    private final BidiMap<State, State> isomorphism;

    public IsomorphismLogic(TransitionSystem lts1, TransitionSystem lts2, boolean checkLabels) {
        this.isomorphism = IsomorphismLogic.construct(lts1, lts2, checkLabels);
    }

    private static BidiMap<State, State> construct(TransitionSystem lts1, TransitionSystem lts2, boolean checkLabels) {
        if (lts1.getNodes().size() != lts2.getNodes().size()) {
            return new DualHashBidiMap<State, State>();
        }
        if (checkLabels) {
            boolean precond2;
            boolean precond1 = IsomorphismLogic.checkPreconditions(lts1);
            if (precond1 != (precond2 = IsomorphismLogic.checkPreconditions(lts2))) {
                return new DualHashBidiMap<State, State>();
            }
            if (precond1 && precond2) {
                return IsomorphismLogic.checkViaDepthSearch(lts1, lts2);
            }
        }
        return new IsomorphismLogicComplex(lts1, lts2, checkLabels).getIsomorphism();
    }

    private static boolean checkPreconditions(TransitionSystem lts) {
        return new Deterministic(lts).isDeterministic() && new TotallyReachable(lts).isTotallyReachable();
    }

    private static BidiMap<State, State> checkViaDepthSearch(TransitionSystem lts1, TransitionSystem lts2) {
        DualHashBidiMap<State, State> result = new DualHashBidiMap<State, State>();
        Set<String> alphabet = lts1.getAlphabet();
        if (!alphabet.equals(lts2.getAlphabet())) {
            return result;
        }
        ArrayDeque<Pair<State, State>> unhandled = new ArrayDeque<Pair<State, State>>();
        IsomorphismLogic.visit(result, unhandled, lts1.getInitialState(), lts2.getInitialState());
        while (!unhandled.isEmpty()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            Pair pair = (Pair)unhandled.remove();
            State state1 = (State)pair.getFirst();
            State state2 = (State)pair.getSecond();
            for (String label : alphabet) {
                State follow2;
                State follow1 = IsomorphismLogic.follow(state1, label);
                if (IsomorphismLogic.visit(result, unhandled, follow1, follow2 = IsomorphismLogic.follow(state2, label))) continue;
                return new DualHashBidiMap<State, State>();
            }
        }
        return result;
    }

    private static State follow(State state, String label) {
        Set<Arc> postset = state.getPostsetEdgesByLabel(label);
        assert (postset.isEmpty() || postset.size() == 1) : "A deterministic LTS is not deterministic?";
        Iterator<Arc> iterator = postset.iterator();
        if (iterator.hasNext()) {
            Arc arc = iterator.next();
            return (State)arc.getTarget();
        }
        return null;
    }

    private static boolean visit(BidiMap<State, State> partialIsomorphism, Queue<Pair<State, State>> unhandled, State state1, State state2) {
        if (state1 == null && state2 == null) {
            return true;
        }
        if (state1 == null || state2 == null) {
            return false;
        }
        State oldState1 = partialIsomorphism.getKey(state2);
        if (state1.equals(oldState1)) {
            return true;
        }
        if (oldState1 != null) {
            return false;
        }
        State oldState2 = partialIsomorphism.put(state1, state2);
        if (oldState2 != null) {
            assert (!state2.equals(oldState2));
            return false;
        }
        unhandled.add(new Pair<State, State>(state1, state2));
        return true;
    }

    public boolean isIsomorphic() {
        return !this.isomorphism.isEmpty();
    }

    public BidiMap<State, State> getIsomorphism() {
        return UnmodifiableBidiMap.unmodifiableBidiMap(this.isomorphism);
    }
}

