/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.isolated;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.analysis.isolated.Isolated;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class IsolatedModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getName() {
        return "isolated";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn", PetriNet.class, "The Petri net that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("isolated", Boolean.class, "success");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNet pn = input.getParameter("pn", PetriNet.class);
        boolean isolated = false;
        isolated = Isolated.checkIsolated(pn);
        output.setReturnValue("isolated", Boolean.class, isolated);
    }

    @Override
    public String getShortDescription() {
        return "Check if a Petri net contains isolated elements";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ". A Petri net contains isolated elements when at least one element's pre- and postset is empty.";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

