/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.invariants;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import uniol.apt.util.Pair;

public class Matrix
implements Iterable<List<Integer>> {
    private int iRows;
    private int iCols;
    private final List<List<Integer>> lRows;

    public static Matrix identity(int m, int n) {
        Matrix result = new Matrix(m, n);
        for (int i = 0; i < m; ++i) {
            List<Integer> row = result.lRows.get(i);
            if (i >= n) continue;
            row.set(i, 1);
        }
        return result;
    }

    public Matrix(int m, int n) {
        this.iRows = m;
        this.iCols = n;
        this.lRows = new ArrayList<List<Integer>>(this.iRows);
        for (int i = 0; i < this.iRows; ++i) {
            ArrayList<Integer> col = new ArrayList<Integer>(this.iCols);
            for (int j = 0; j < this.iCols; ++j) {
                col.add(0);
            }
            this.lRows.add(col);
        }
    }

    public Matrix(int[][] src) {
        this.iRows = src.length;
        this.iCols = src[0].length;
        this.lRows = new ArrayList<List<Integer>>(this.iRows);
        for (int i = 0; i < this.iRows; ++i) {
            int[] row = src[i];
            ArrayList<Integer> vRow = new ArrayList<Integer>(this.iCols);
            for (int j = 0; j < this.iCols; ++j) {
                vRow.add(row[j]);
            }
            this.lRows.add(vRow);
        }
    }

    public int getRowCount() {
        return this.iRows;
    }

    public int getColumnCount() {
        return this.iCols;
    }

    public List<Integer> getRow(int i) {
        return this.lRows.get(i);
    }

    public List<Integer> getColumn(int i) {
        ArrayList<Integer> result = new ArrayList<Integer>(this.iCols);
        for (List<Integer> row : this.lRows) {
            result.add(row.get(i));
        }
        return result;
    }

    public Pair<Integer, List<Integer>> getNoneZeroRow() {
        for (List<Integer> row : this.lRows) {
            for (int i = 0; i < row.size(); ++i) {
                if (row.get(i) == 0) continue;
                return new Pair<Integer, List<Integer>>(i, row);
            }
        }
        return null;
    }

    public void deleteColumn(int j) {
        for (List<Integer> row : this.lRows) {
            row.remove(j);
        }
        --this.iCols;
    }

    public boolean isZero() {
        for (List<Integer> row : this.lRows) {
            for (Integer i : row) {
                if (i == 0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Iterator<List<Integer>> iterator() {
        return this.lRows.iterator();
    }

    public String toString() {
        return "Matrix{lRows=" + this.lRows + '}';
    }
}

