/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.invariants;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uniol.apt.adt.pn.Node;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.analysis.invariants.Matrix;
import uniol.apt.analysis.invariants.Vector;
import uniol.apt.util.MathTools;
import uniol.apt.util.Pair;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class InvariantCalculator {
    private InvariantCalculator() {
    }

    private static List<PpPm> calcPpPm(Matrix matC) {
        ArrayList<PpPm> result = new ArrayList<PpPm>();
        for (List<Integer> h : matC) {
            result.add(new PpPm(h));
        }
        return result;
    }

    private static List<Integer> check11(List<PpPm> pppms) {
        for (PpPm pppm : pppms) {
            boolean pmEmpty = pppm.pMinus.isEmpty();
            boolean ppEmpty = pppm.pPlus.isEmpty();
            if (!pmEmpty && !ppEmpty || pmEmpty && ppEmpty) continue;
            return pppm.h;
        }
        return null;
    }

    private static Check11bResult check11b(List<PpPm> pppms) {
        for (PpPm pppm : pppms) {
            if (pppm.pMinus.size() == 1) {
                return new Check11bResult(pppm.pMinus.get(0), pppm.h, pppm.pPlus);
            }
            if (pppm.pPlus.size() != 1) continue;
            return new Check11bResult(pppm.pPlus.get(0), pppm.h, pppm.pMinus);
        }
        return null;
    }

    private static Set<List<Integer>> calcInvariantsPIPE(int[][] mat) {
        if (mat.length == 0 || mat[0].length == 0) {
            return new HashSet<List<Integer>>();
        }
        Matrix matC = new Matrix(mat);
        Matrix matB = Matrix.identity(matC.getColumnCount(), matC.getColumnCount());
        while (!matC.isZero()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            List<PpPm> pppms = InvariantCalculator.calcPpPm(matC);
            List<Integer> h = InvariantCalculator.check11(pppms);
            if (h != null) {
                for (int j = matC.getColumnCount() - 1; j >= 0; --j) {
                    if (h.get(j) == 0) continue;
                    matC.deleteColumn(j);
                    matB.deleteColumn(j);
                }
                continue;
            }
            Check11bResult chkResult = InvariantCalculator.check11b(pppms);
            if (chkResult != null) {
                for (Integer j : chkResult.p) {
                    Integer chk = Math.abs(chkResult.h.get(chkResult.k));
                    Integer chj = Math.abs(chkResult.h.get(j));
                    for (List<Integer> row : matC) {
                        row.set(j, row.get(j) * chk + row.get(chkResult.k) * chj);
                    }
                    for (List<Integer> row : matB) {
                        row.set(j, row.get(j) * chk + row.get(chkResult.k) * chj);
                    }
                }
                matC.deleteColumn(chkResult.k);
                matB.deleteColumn(chkResult.k);
                continue;
            }
            Pair<Integer, List<Integer>> pair = matC.getNoneZeroRow();
            h = pair.getSecond();
            int k = pair.getFirst();
            for (int j = 0; j < h.size(); ++j) {
                if (j == k || h.get(j) == 0) continue;
                int cHj = h.get(j);
                int cHk = h.get(k);
                int alpha = Math.signum(cHj) * Math.signum(cHk) < 0.0f ? Math.abs(cHj) : -Math.abs(cHj);
                int beta = Math.abs(cHk);
                for (List<Integer> row : matC) {
                    row.set(j, row.get(j) * beta + row.get(k) * alpha);
                }
                for (List<Integer> row : matB) {
                    row.set(j, row.get(j) * beta + row.get(k) * alpha);
                }
            }
            matC.deleteColumn(k);
            matB.deleteColumn(k);
        }
        HashSet<List<Integer>> colsB = new HashSet<List<Integer>>(2 * matB.getColumnCount());
        for (int i = 0; i < matB.getColumnCount(); ++i) {
            List<Integer> col = matB.getColumn(i);
            InvariantCalculator.normalize(col);
            colsB.add(col);
        }
        HashSet<List> treated = new HashSet<List>();
        while (!colsB.isEmpty()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            ArrayList<List> ppmPlus = null;
            ArrayList<List> ppmMinus = null;
            BitSet negRows = new BitSet(matB.getRowCount());
            int minRow = -1;
            int minRowWeight = -1;
            int rowsize = ((List)colsB.iterator().next()).size();
            for (int row = 0; row < rowsize; ++row) {
                int weight = 0;
                ArrayList<List> arrayList = new ArrayList<List>();
                ArrayList<List> tmpPlus = new ArrayList<List>();
                for (List list : colsB) {
                    int val = (Integer)list.get(row);
                    if (val < 0) {
                        arrayList.add(list);
                        ++weight;
                        negRows.set(row);
                        continue;
                    }
                    if (val <= 0) continue;
                    tmpPlus.add(list);
                    ++weight;
                }
                if (arrayList.isEmpty() || minRow != -1 && minRowWeight <= weight) continue;
                minRow = row;
                minRowWeight = weight;
                ppmMinus = arrayList;
                ppmPlus = tmpPlus;
            }
            int targetRow = minRow;
            if (targetRow == -1) break;
            for (List list : colsB) {
                boolean isok = true;
                int negRow = negRows.nextSetBit(0);
                while (negRow >= 0) {
                    if ((Integer)list.get(negRow) != 0) {
                        isok = false;
                        break;
                    }
                    negRow = negRows.nextSetBit(negRow + 1);
                }
                if (!isok) continue;
                treated.add(list);
            }
            colsB.removeAll(treated);
            for (List list : colsB) {
                int val = (Integer)list.get(targetRow);
                if (val > 0) {
                    ppmPlus.add(list);
                    continue;
                }
                if (val >= 0) continue;
                ppmMinus.add(list);
            }
            if (ppmPlus.isEmpty()) continue;
            for (List list : ppmPlus) {
                for (List colk : ppmMinus) {
                    ArrayList<Integer> arrayList = new ArrayList<Integer>(list.size());
                    int a = -((Integer)colk.get(targetRow)).intValue();
                    int b = (Integer)list.get(targetRow);
                    for (int i = 0; i < matB.getRowCount(); ++i) {
                        arrayList.add(a * (Integer)list.get(i) + b * (Integer)colk.get(i));
                    }
                    InvariantCalculator.normalize(arrayList);
                    colsB.add(arrayList);
                }
            }
            colsB.removeAll(ppmMinus);
        }
        colsB.addAll(treated);
        return colsB;
    }

    private static void normalize(List<Integer> invariants) {
        int gcd = MathTools.gcd(invariants);
        if (gcd > 1) {
            for (int j = 0; j < invariants.size(); ++j) {
                invariants.set(j, invariants.get(j) / gcd);
            }
        }
    }

    private static Set<List<Integer>> calcInvariantsFarkas(int[][] mat) {
        int i;
        int rows = mat.length;
        if (mat.length == 0 || mat[0].length == 0) {
            return new HashSet<List<Integer>>();
        }
        int cols = mat[0].length;
        int dcols = cols + rows;
        ArrayList d = new ArrayList();
        for (i = 0; i < rows; ++i) {
            ArrayList<Integer> row = new ArrayList<Integer>();
            d.add(i, row);
            for (int j = 0; j < dcols; ++j) {
                if (j < cols) {
                    row.add(j, mat[i][j]);
                    continue;
                }
                row.add(j, i != j - cols ? 0 : 1);
            }
        }
        for (i = 0; i < cols; ++i) {
            int n;
            int offset = 1;
            do {
                rows = d.size();
                for (n = 0; n < rows - 1; ++n) {
                    List z1 = (List)d.get(n);
                    for (int j2 = n + offset; j2 < rows; ++j2) {
                        InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                        List z2 = (List)d.get(j2);
                        if (!(Math.signum(((Integer)z1.get(i)).intValue()) * Math.signum(((Integer)z2.get(i)).intValue()) < 0.0f)) continue;
                        int z1abs = Math.abs((Integer)z1.get(i));
                        int z2abs = Math.abs((Integer)z2.get(i));
                        ArrayList<Integer> z = new ArrayList<Integer>();
                        for (int k = 0; k < dcols; ++k) {
                            int a = z2abs * (Integer)z1.get(k);
                            int b = z1abs * (Integer)z2.get(k);
                            z.add(k, a + b);
                        }
                        int gcd = MathTools.gcd(z);
                        if (gcd != 1) {
                            for (int k = 0; k < dcols; ++k) {
                                z.set(k, (Integer)z.get(k) / gcd);
                            }
                        }
                        d.add(z);
                    }
                }
                offset = rows;
            } while (rows < d.size());
            for (n = d.size() - 1; n >= 0; --n) {
                if ((Integer)((List)d.get(n)).get(i) == 0) continue;
                d.remove(n);
            }
        }
        HashSet<List<Integer>> result = new HashSet<List<Integer>>();
        for (List list : d) {
            result.add(list.subList(cols, dcols));
        }
        return result;
    }

    private static int[][] transposeMatrix(int[][] mat) {
        if (mat.length == 0) {
            return mat;
        }
        int rows = mat.length;
        int cols = mat[0].length;
        int[][] matT = new int[cols][rows];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                matT[j][i] = mat[i][j];
            }
        }
        return matT;
    }

    public static Set<List<Integer>> calcSInvariants(PetriNet pn) {
        return InvariantCalculator.calcSInvariants(pn, InvariantAlgorithm.PIPE);
    }

    public static Set<List<Integer>> calcSInvariants(PetriNet pn, InvariantAlgorithm algo) {
        switch (algo) {
            case FARKAS: {
                return InvariantCalculator.calcInvariantsFarkas(pn.getIncidenceMatrix());
            }
            case PIPE: {
                return InvariantCalculator.calcInvariantsPIPE(InvariantCalculator.transposeMatrix(pn.getIncidenceMatrix()));
            }
        }
        return InvariantCalculator.calcInvariantsFarkas(pn.getIncidenceMatrix());
    }

    public static Set<List<Integer>> calcTInvariants(PetriNet pn) {
        return InvariantCalculator.calcTInvariants(pn, InvariantAlgorithm.PIPE);
    }

    public static Set<List<Integer>> calcTInvariants(PetriNet pn, InvariantAlgorithm algo) {
        switch (algo) {
            case FARKAS: {
                return InvariantCalculator.calcInvariantsFarkas(InvariantCalculator.transposeMatrix(pn.getIncidenceMatrix()));
            }
            case PIPE: {
                return InvariantCalculator.calcInvariantsPIPE(pn.getIncidenceMatrix());
            }
        }
        return InvariantCalculator.calcInvariantsFarkas(InvariantCalculator.transposeMatrix(pn.getIncidenceMatrix()));
    }

    public static Vector coveredBySInvariants(PetriNet pn) {
        return InvariantCalculator.coveredBySInvariants(pn, InvariantAlgorithm.PIPE);
    }

    public static Vector coveredBySInvariants(PetriNet pn, InvariantAlgorithm algo) {
        Set<List<Integer>> invariants = InvariantCalculator.calcSInvariants(pn, algo);
        return InvariantCalculator.coveredBySInvariants(pn, invariants);
    }

    public static Vector coveredBySInvariants(PetriNet pn, Set<List<Integer>> invariants) {
        if (invariants.isEmpty()) {
            return null;
        }
        Vector invariant = new Vector();
        for (int i = 0; i < pn.getPlaces().size(); ++i) {
            int v = 0;
            for (List<Integer> y : invariants) {
                v += y.get(i).intValue();
            }
            if (v == 0) {
                return null;
            }
            invariant.add(v);
        }
        return invariant;
    }

    public static Vector coveredByTInvariants(PetriNet pn) {
        return InvariantCalculator.coveredByTInvariants(pn, InvariantAlgorithm.PIPE);
    }

    public static Vector coveredByTInvariants(PetriNet pn, InvariantAlgorithm algo) {
        Set<List<Integer>> invariants = InvariantCalculator.calcTInvariants(pn, algo);
        return InvariantCalculator.coveredByTInvariants(pn, invariants);
    }

    public static Vector coveredByTInvariants(PetriNet pn, Set<List<Integer>> invariants) {
        if (invariants.isEmpty()) {
            return null;
        }
        Vector invariant = new Vector();
        for (int i = 0; i < pn.getTransitions().size(); ++i) {
            int v = 0;
            for (List<Integer> y : invariants) {
                v += y.get(i).intValue();
            }
            if (v == 0) {
                return null;
            }
            invariant.add(v);
        }
        return invariant;
    }

    public static <T extends Node> Set<Map<T, Integer>> getMapping(Set<T> nodes, Set<List<Integer>> invariants) {
        HashSet<Map<T, Integer>> ret = new HashSet<Map<T, Integer>>();
        for (List<Integer> invariant : invariants) {
            HashMap<Node, Integer> map = new HashMap<Node, Integer>();
            int i = 0;
            for (Node node : nodes) {
                map.put(node, invariant.get(i));
                ++i;
            }
            ret.add(map);
        }
        return ret;
    }

    private static class Check11bResult {
        public final Integer k;
        public final List<Integer> h;
        public final List<Integer> p;

        public Check11bResult(Integer k, List<Integer> h, List<Integer> p) {
            this.k = k;
            this.h = h;
            this.p = p;
        }
    }

    private static class PpPm {
        public final List<Integer> h;
        public final List<Integer> pPlus;
        public final List<Integer> pMinus;

        public PpPm(List<Integer> h) {
            this.h = h;
            this.pMinus = new ArrayList<Integer>();
            this.pPlus = new ArrayList<Integer>();
            for (int j = 0; j < h.size(); ++j) {
                if (h.get(j) < 0) {
                    this.pMinus.add(j);
                    continue;
                }
                if (h.get(j) <= 0) continue;
                this.pPlus.add(j);
            }
        }
    }

    public static enum InvariantAlgorithm {
        FARKAS,
        PIPE;

    }
}

