/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.invariants;

import java.util.Set;
import uniol.apt.adt.pn.Node;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.analysis.invariants.InvariantCalculator;
import uniol.apt.analysis.invariants.InvariantKind;
import uniol.apt.analysis.invariants.Vector;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class CoveredByInvariantModule
extends AbstractModule
implements InterruptibleModule {
    private static final String DESCRIPTION = "Check if a Petri net is covered by an S-invariant or a T-invariant";
    private static final String TITLE = "covered by invariant";
    private static final String NAME = "covered_by_invariant";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("net", PetriNet.class, "The Petri net that should be examined", new String[0]);
        inputSpec.addParameter("inv", InvariantKind.class, "Parameter 's' for s-invariants and 't' for t-invariants.", new String[0]);
        inputSpec.addOptionalParameterWithDefault("algo", InvariantCalculator.InvariantAlgorithm.class, InvariantCalculator.InvariantAlgorithm.PIPE, "p", "Parameter 'f' for farkas algorithm and 'p' for the adapted farkas algorithm of pipe.", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue(TITLE, Boolean.class, "success");
        outputSpec.addReturnValue("mapping", String.class, new String[0]);
        outputSpec.addReturnValue("invariant", Vector.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        Set<Node> nodes;
        Vector invariant;
        PetriNet pn = input.getParameter("net", PetriNet.class);
        InvariantKind kind = input.getParameter("inv", InvariantKind.class);
        InvariantCalculator.InvariantAlgorithm algo = input.getParameter("algo", InvariantCalculator.InvariantAlgorithm.class);
        switch (kind) {
            case S: {
                invariant = InvariantCalculator.coveredBySInvariants(pn, algo);
                nodes = pn.getPlaces();
                break;
            }
            case T: {
                invariant = InvariantCalculator.coveredByTInvariants(pn, algo);
                nodes = pn.getTransitions();
                break;
            }
            default: {
                throw new ModuleException("Parameter for " + this.getName() + " has to be [s/t]");
            }
        }
        output.setReturnValue(TITLE, Boolean.class, invariant != null);
        StringBuilder sb = new StringBuilder("[");
        for (Node node : nodes) {
            sb.append(node.getId()).append("; ");
        }
        if (sb.length() - 2 >= 0) {
            sb.replace(sb.length() - 2, sb.length() - 1, "]");
        } else {
            sb.append("]");
        }
        output.setReturnValue("mapping", String.class, sb.toString());
        output.setReturnValue("invariant", Vector.class, invariant);
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public String getShortDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ".\n\nAn invariant is a semi-positive vector from the nullspace of the incidence matrix C. For a T-invariant x\u22650 this means C*x=0 and a S-invariant x\u22650 satisfies C\u1d40*x=0. This module checks if a positive S- or T-invariant exists, that is an invariant without an entry equal to zero.";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

