/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.invariants;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uniol.apt.adt.pn.Node;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.analysis.invariants.InvariantCalculator;
import uniol.apt.analysis.invariants.InvariantKind;
import uniol.apt.analysis.invariants.Vector;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class ComputeMinSemiPosInvariantsModule
extends AbstractModule
implements InterruptibleModule {
    private static final String DESCRIPTION = "Compute a generator set of S- or T-invariants";
    private static final String TITLE = "invariants";
    private static final String NAME = "invariants";

    @Override
    public String getName() {
        return "invariants";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn", PetriNet.class, "The Petri net that should be examined", new String[0]);
        inputSpec.addParameter("inv", InvariantKind.class, "Parameter 's' for s-invariants and 't' for t-invariants.", new String[0]);
        inputSpec.addOptionalParameterWithDefault("algo", InvariantCalculator.InvariantAlgorithm.class, InvariantCalculator.InvariantAlgorithm.PIPE, "p", "Parameter 'f' for Farkas algorithm and 'p' for the adapted Farkas algorithm of PIPE.", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("mapping", String.class, new String[0]);
        outputSpec.addReturnValue("invariants", Set.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        Set<Node> nodes;
        PetriNet pn = input.getParameter("pn", PetriNet.class);
        InvariantKind kind = input.getParameter("inv", InvariantKind.class);
        InvariantCalculator.InvariantAlgorithm algo = input.getParameter("algo", InvariantCalculator.InvariantAlgorithm.class);
        Set<List<Integer>> invariants = null;
        switch (kind) {
            case S: {
                invariants = InvariantCalculator.calcSInvariants(pn, algo);
                nodes = pn.getPlaces();
                break;
            }
            case T: {
                invariants = InvariantCalculator.calcTInvariants(pn, algo);
                nodes = pn.getTransitions();
                break;
            }
            default: {
                throw new ModuleException("Parameter for " + this.getName() + " has to be [s/t]");
            }
        }
        StringBuilder sb = new StringBuilder("[");
        for (Node node : nodes) {
            sb.append(node.getId()).append("; ");
        }
        if (sb.length() - 2 >= 0) {
            sb.replace(sb.length() - 2, sb.length() - 1, "]");
        } else {
            sb.append("]");
        }
        output.setReturnValue("mapping", String.class, sb.toString());
        HashSet<Vector> invs = new HashSet<Vector>();
        for (List<Integer> list : invariants) {
            invs.add(new Vector((Collection<? extends Integer>)list));
        }
        output.setReturnValue("invariants", Set.class, invs);
    }

    @Override
    public String getTitle() {
        return "invariants";
    }

    @Override
    public String getShortDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ".\n\nAn invariant is a semi-positive vector from the nullspace of the incidence matrix C. For a T-invariant x\u22650 this means C*x=0 and a S-invariant x\u22650 satisfies C\u1d40*x=0. This module finds the set of generators for all S- or T-invariants.";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

