/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.homogeneous;

import uniol.apt.adt.pn.Flow;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.analysis.homogeneous.Homogeneous;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;
import uniol.apt.util.Pair;

public class HomogeneousModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getName() {
        return "homogeneous";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("net", PetriNet.class, "The Petri net that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("homogeneous", Boolean.class, "success");
        outputSpec.addReturnValue("witness1", Flow.class, new String[0]);
        outputSpec.addReturnValue("witness2", Flow.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        Homogeneous homogeneous = new Homogeneous();
        PetriNet pn = input.getParameter("net", PetriNet.class);
        Pair<Flow, Flow> counterexample = homogeneous.check(pn);
        output.setReturnValue("homogeneous", Boolean.class, counterexample == null);
        if (counterexample != null) {
            output.setReturnValue("witness1", Flow.class, counterexample.getFirst());
            output.setReturnValue("witness2", Flow.class, counterexample.getSecond());
        }
    }

    @Override
    public String getTitle() {
        return "Homogeneous";
    }

    @Override
    public String getShortDescription() {
        return "Check if a Petri net is homogeneous";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ".\n\nA Petri net is an homogeneous net if \u2200p\u2208P:\u2200t\u2081,t\u2082\u2208p\u00b0: F(p,t\u2081)=F(p,t\u2082)";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

