/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.fcnet;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.analysis.fcnet.FCNet;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class FCNetModule
extends AbstractModule
implements InterruptibleModule {
    private static final String SHORTDESCRIPTION = "Check if a Petri net is restricted-free-choice";
    private static final String LONGDESCRIPTION = "Check if a Petri net is restricted-free-choice. That is:\n\\forall t_1,t_s\\in T\\colon{}^\\bullet t_1\\cap{}^\\bullet t_2\\neq\\es\n\\impl|{}^\\bullet t_1|=|{}^\\bullet t_2|=1";
    private static final String TITLE = "restricted-free-choice";
    private static final String NAME = "rfc";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("net", PetriNet.class, "The Petri net that should be examined", "plain");
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue(NAME, Boolean.class, "success");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNet pn = input.getParameter("net", PetriNet.class);
        FCNet net = new FCNet(pn);
        output.setReturnValue(NAME, Boolean.class, net.check());
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public String getShortDescription() {
        return SHORTDESCRIPTION;
    }

    @Override
    public String getLongDescription() {
        return LONGDESCRIPTION;
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

