/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.fcnet;

import java.util.Collections;
import java.util.Set;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Transition;
import uniol.apt.analysis.exception.PreconditionFailedException;
import uniol.apt.analysis.plain.Plain;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class FCNet {
    private final PetriNet pn;

    public FCNet(PetriNet pn) {
        this.pn = pn;
    }

    public boolean check() throws PreconditionFailedException {
        if (!new Plain().checkPlain(this.pn)) {
            throw new PreconditionFailedException("the net is not plain.");
        }
        for (Transition t1 : this.pn.getTransitions()) {
            for (Transition t2 : this.pn.getTransitions()) {
                Set<Place> set2;
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                Set<Place> set1 = t1.getPreset();
                if (Collections.disjoint(set1, set2 = t2.getPreset()) || set1.size() == 1 && set2.size() == 1) continue;
                return false;
            }
        }
        return true;
    }
}

