/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.fc;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.analysis.fc.WeightedFreeChoice;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class WFCModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getName() {
        return "wfc";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("net", PetriNet.class, "The Petri net that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("wfc", Boolean.class, "success");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNet pn = input.getParameter("net", PetriNet.class);
        WeightedFreeChoice fc = new WeightedFreeChoice();
        output.setReturnValue("wfc", Boolean.class, fc.check(pn));
    }

    @Override
    public String getTitle() {
        return "Weighted Free Choice";
    }

    @Override
    public String getShortDescription() {
        return "Check if a Petri net is weighted free-choice";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ". That is: \\forall t1,t2 \\in T: ^{\\bullet}t1 \\Cap ^{\\bullet}t2 \\neq \\emptyset \\Rightarrow ^{\\bullet}t1 \\eq ^{\\bullet}t2.";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

