/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.fairness;

import uniol.apt.adt.PetriNetOrTransitionSystem;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.fairness.Fairness;
import uniol.apt.analysis.fairness.FairnessResult;
import uniol.apt.analysis.presynthesis.pps.Path;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class FairnessModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getShortDescription() {
        return "Check if a Petri net or transition system is fair";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ". A transition system is fair if for every infinite firing sequence every infintely often k-activated event is fired infinitely often.";
    }

    @Override
    public String getName() {
        return "fairness";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pnTs", PetriNetOrTransitionSystem.class, "The Petri net or transition system that should be examined", new String[0]);
        inputSpec.addOptionalParameterWithDefault("k", Integer.class, 0, "0", "If given, break if a k-unfair situation is found", new String[0]);
        inputSpec.addOptionalParameterWithoutDefault("t", String.class, "If given, fairness regarding this event is checked", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("fair", Boolean.class, "success");
        outputSpec.addReturnValue("witness_state", State.class, new String[0]);
        outputSpec.addReturnValue("witness_firing_sequence_start", Path.class, new String[0]);
        outputSpec.addReturnValue("witness_firing_sequence_cycle", Path.class, new String[0]);
        outputSpec.addReturnValue("witness_firing_sequence_enable", Path.class, new String[0]);
        outputSpec.addReturnValue("smallest_K", Integer.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        TransitionSystem ts = input.getParameter("pnTs", PetriNetOrTransitionSystem.class).getReachabilityLTS();
        int k = input.getParameter("k", Integer.class);
        String t = input.getParameter("t", String.class);
        FairnessResult result = t == null ? Fairness.checkFairness(ts, k) : Fairness.checkFairness(ts, k, ts.getEvent(t));
        boolean fair = result.isFair();
        output.setReturnValue("fair", Boolean.class, fair);
        if (!fair) {
            output.setReturnValue("witness_state", State.class, result.unfairState);
            output.setReturnValue("witness_firing_sequence_start", Path.class, new Path(result.sequence));
            output.setReturnValue("witness_firing_sequence_cycle", Path.class, new Path(result.cycle));
            output.setReturnValue("witness_firing_sequence_enable", Path.class, new Path(result.enabling));
            output.setReturnValue("smallest_K", Integer.class, result.k);
        }
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN, Category.LTS};
    }
}

