/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.fairness;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.Event;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.cycles.lts.ComputeSmallestCycles;
import uniol.apt.analysis.cycles.lts.Cycle;
import uniol.apt.analysis.fairness.FairnessResult;
import uniol.apt.util.SpanningTree;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class Fairness {
    private final TransitionSystem ts;
    private final Set<Cycle> cycles;

    public static FairnessResult checkFairness(TransitionSystem ts) {
        return Fairness.checkFairness(ts, 0);
    }

    public static FairnessResult checkFairness(TransitionSystem ts, int k) {
        Fairness dfc = new Fairness(ts);
        for (Event e : ts.getAlphabetEvents()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            FairnessResult result = dfc.checkEvent(e, k);
            if (result.isFair()) continue;
            return result;
        }
        return new FairnessResult(ts);
    }

    public static FairnessResult checkFairness(TransitionSystem ts, Event e) {
        return Fairness.checkFairness(ts, 0, e);
    }

    public static FairnessResult checkFairness(TransitionSystem ts, int k, Event e) {
        return new Fairness(ts).checkEvent(e, k);
    }

    public Fairness(TransitionSystem ts) {
        this.ts = ts;
        Set<State> unreachable = SpanningTree.get(ts, ts.getInitialState()).getUnreachableNodes();
        this.cycles = new HashSet<Cycle>();
        for (Cycle c : new ComputeSmallestCycles().computePVsOfSmallestCyclesViaCycleSearch(ts, false)) {
            if (unreachable.contains(c.getNodes().iterator().next())) continue;
            this.cycles.add(c);
        }
    }

    public FairnessResult checkEvent(Event e, int k) {
        int n;
        HashMap<State, Integer> unfairness = new HashMap<State, Integer>();
        HashMap<State, Arc> successors = new HashMap<State, Arc>();
        int d = 0;
        HashSet<State> prevDepthStates = new HashSet<State>();
        for (Arc arc : this.ts.getEdges()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            if (!e.equals(arc.getEvent())) continue;
            State src = (State)arc.getSource();
            unfairness.put(src, 0);
            prevDepthStates.add(src);
        }
        while (!prevDepthStates.isEmpty()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            ++d;
            HashSet<State> curDepthStates = new HashSet<State>();
            for (State s : prevDepthStates) {
                for (Arc arc : s.getPresetEdges()) {
                    State src = (State)arc.getSource();
                    if (unfairness.containsKey(src)) continue;
                    unfairness.put(src, d);
                    successors.put(src, arc);
                    curDepthStates.add(src);
                }
            }
            prevDepthStates = curDepthStates;
        }
        State witness = null;
        int n2 = Integer.MAX_VALUE;
        ArrayList<Arc> witnessCycle = null;
        int witnessPos = Integer.MAX_VALUE;
        for (Cycle c : this.cycles) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            if (c.getParikhVector().get(e.getLabel()) > 0) continue;
            int i = -1;
            for (State s : c.getNodes()) {
                ++i;
                Integer distance = (Integer)unfairness.get(s);
                if (distance == null || witness != null && distance >= n) continue;
                witness = s;
                witnessCycle = new ArrayList<Arc>(c.getArcs());
                n = distance;
                witnessPos = i;
            }
            if (n > k) continue;
            break;
        }
        if (witness == null) {
            return new FairnessResult(this.ts);
        }
        Collections.rotate(witnessCycle, -witnessPos);
        List<Arc> list = SpanningTree.get(this.ts, this.ts.getInitialState()).getEdgePathFromStart(witness);
        ArrayList<Arc> enabling = new ArrayList<Arc>();
        Arc a = (Arc)successors.get(witness);
        while (a != null) {
            enabling.add(a);
            a = (Arc)successors.get(a.getTarget());
        }
        return new FairnessResult(this.ts, witness, e, n, list, witnessCycle, enabling);
    }
}

