/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.factorization;

import java.util.HashSet;
import java.util.Set;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.TransitionSystem;

public class TransitionSystemFilter {
    private TransitionSystemFilter() {
    }

    public static TransitionSystem removeArcsByLabel(TransitionSystem ts, Set<String> labels) {
        HashSet<Arc> toRemove = new HashSet<Arc>();
        TransitionSystem result = new TransitionSystem(ts);
        for (Arc arc : result.getEdges()) {
            if (!labels.contains(arc.getLabel())) continue;
            toRemove.add(arc);
        }
        for (Arc arc : toRemove) {
            result.removeArc(arc);
        }
        return result;
    }

    public static TransitionSystem retainArcsByLabel(TransitionSystem ts, Set<String> labels) {
        HashSet<String> otherLabels = new HashSet<String>(ts.getAlphabet());
        otherLabels.removeAll(labels);
        return TransitionSystemFilter.removeArcsByLabel(ts, otherLabels);
    }
}

