/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.factorization;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.deterministic.Deterministic;
import uniol.apt.analysis.exception.NonDeterministicException;
import uniol.apt.analysis.factorization.Factorization;
import uniol.apt.util.DebugUtil;
import uniol.apt.util.DifferentPairsIterable;
import uniol.apt.util.DomainEquivalenceRelation;
import uniol.apt.util.Pair;

public class SynthesisFactorisation {
    public Set<TransitionSystem> factorize(TransitionSystem ts) throws NonDeterministicException {
        DomainEquivalenceRelation<String> eq = new DomainEquivalenceRelation<String>(ts.getAlphabet());
        new Deterministic(ts, true).throwIfNonDeterministic();
        new Deterministic(ts, false).throwIfNonDeterministic();
        for (State s : ts.getNodes()) {
            for (Pair<IntermediateState, IntermediateState> pair : new DifferentPairsIterable<IntermediateState>(SynthesisFactorisation.getArcsWithDirection(s))) {
                IntermediateState imState1 = pair.getFirst();
                IntermediateState imState2 = pair.getSecond();
                if (eq.isEquivalent(imState1.getLabel(), imState2.getLabel())) continue;
                State state1 = imState1.getSuccessorOfState(imState2.getState());
                State state2 = imState2.getSuccessorOfState(imState1.getState());
                if (state1 != null && state1.equals(state2)) continue;
                eq.joinClasses(imState1.getLabel(), imState2.getLabel());
            }
            if (eq.size() != 1) continue;
            return Collections.singleton(ts);
        }
        HashSet<TransitionSystem> factors = new HashSet<TransitionSystem>();
        for (Set<String> set : eq) {
            factors.add(this.createFactor(ts, set));
        }
        DebugUtil.debugFormat("Found %d candidate factors", factors.size());
        return factors;
    }

    private static Set<IntermediateState> getArcsWithDirection(State s) {
        HashSet<IntermediateState> result = new HashSet<IntermediateState>();
        for (Arc arc : s.getPostsetEdges()) {
            result.add(new IntermediateForwardState((State)arc.getTarget(), arc.getLabel()));
        }
        for (Arc arc : s.getPresetEdges()) {
            result.add(new IntermediateBackwardState((State)arc.getSource(), arc.getLabel()));
        }
        return result;
    }

    private TransitionSystem createFactor(TransitionSystem ts, Set<String> labels) {
        return Factorization.createFactor(ts, labels);
    }

    private static class IntermediateBackwardState
    extends IntermediateState {
        protected IntermediateBackwardState(State state, String label) {
            super(state, label);
        }

        @Override
        protected State getSuccessorOfState(State s) {
            Iterator<State> iterator = s.getPresetNodesByLabel(this.label).iterator();
            if (iterator.hasNext()) {
                State state = iterator.next();
                return state;
            }
            return null;
        }
    }

    private static class IntermediateForwardState
    extends IntermediateState {
        protected IntermediateForwardState(State state, String label) {
            super(state, label);
        }

        @Override
        protected State getSuccessorOfState(State s) {
            Iterator<State> iterator = s.getPostsetNodesByLabel(this.label).iterator();
            if (iterator.hasNext()) {
                State state = iterator.next();
                return state;
            }
            return null;
        }
    }

    private static abstract class IntermediateState {
        private State state;
        protected String label;

        protected IntermediateState(State state, String label) {
            this.state = state;
            this.label = label;
        }

        protected State getState() {
            return this.state;
        }

        protected String getLabel() {
            return this.label;
        }

        protected abstract State getSuccessorOfState(State var1);
    }
}

