/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.factorization;

import java.util.HashSet;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.factorization.LabelSeparation;
import uniol.apt.analysis.factorization.LabelSeparationResult;
import uniol.apt.analysis.language.Word;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class LabelSeparationModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getName() {
        return "label_separation";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("lts", TransitionSystem.class, "The LTS to check", new String[0]);
        inputSpec.addParameter("T'", Word.class, "Set of labels to check", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("T'-separated", Boolean.class, "success");
        outputSpec.addReturnValue("witness_first_state", State.class, new String[0]);
        outputSpec.addReturnValue("witness_second_state", State.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        TransitionSystem ts = input.getParameter("lts", TransitionSystem.class);
        Word tPrimeWord = input.getParameter("T'", Word.class);
        HashSet<String> tPrime = new HashSet<String>(tPrimeWord);
        if (!ts.getAlphabet().containsAll(tPrime)) {
            throw new ModuleException(String.format("At least one of the supplied labels is not part of the LTS label set.", new Object[0]));
        }
        LabelSeparationResult r = LabelSeparation.checkSeparated(ts, tPrime);
        output.setReturnValue("T'-separated", Boolean.class, r.isSeparated());
        if (!r.isSeparated()) {
            output.setReturnValue("witness_first_state", State.class, r.getWitnessState1());
            output.setReturnValue("witness_second_state", State.class, r.getWitnessState2());
        }
    }

    @Override
    public String getShortDescription() {
        return "Check if a LTS is T'-separated for some label set T'";
    }

    @Override
    public String getLongDescription() {
        return "Check if for all states s != s' it is impossible to go from s to s' using only labels from T' (disregarding arc direction) as well as only labels outside T' (disregarding arc direction)";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.LTS};
    }
}

