/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.factorization;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.connectivity.Connectivity;
import uniol.apt.analysis.factorization.LabelSeparationResult;
import uniol.apt.analysis.factorization.TransitionSystemFilter;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class LabelSeparation {
    private LabelSeparation() {
    }

    public static boolean isSeparated(TransitionSystem ts, Set<String> tPrime) {
        return LabelSeparation.checkSeparated(ts, tPrime).isSeparated();
    }

    public static LabelSeparationResult checkSeparated(TransitionSystem ts, Set<String> tPrime) {
        TransitionSystem ts1 = TransitionSystemFilter.removeArcsByLabel(new TransitionSystem(ts), tPrime);
        TransitionSystem ts2 = TransitionSystemFilter.retainArcsByLabel(new TransitionSystem(ts), tPrime);
        Set wcc1 = Connectivity.getWeaklyConnectedComponents(ts1);
        Set wcc2 = Connectivity.getWeaklyConnectedComponents(ts2);
        Set<Set<String>> wcc1Ids = LabelSeparation.componentStateSetToIdSet(wcc1);
        Set<Set<String>> wcc2Ids = LabelSeparation.componentStateSetToIdSet(wcc2);
        for (Set<String> ids1 : wcc1Ids) {
            for (Set<String> ids2 : wcc2Ids) {
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                HashSet<String> intersection = new HashSet<String>(ids1);
                intersection.retainAll(ids2);
                if (intersection.size() <= 1) continue;
                Iterator iter = intersection.iterator();
                State s1 = ts.getNode((String)iter.next());
                State s2 = ts.getNode((String)iter.next());
                return new LabelSeparationResult(s1, s2);
            }
        }
        return new LabelSeparationResult();
    }

    private static Set<Set<String>> componentStateSetToIdSet(Set<? extends Set<State>> components) {
        HashSet<Set<String>> result = new HashSet<Set<String>>();
        for (Set<State> set : components) {
            HashSet<String> componentIds = new HashSet<String>();
            for (State state : set) {
                componentIds.add(state.getId());
            }
            result.add(componentIds);
        }
        return result;
    }
}

