/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.factorization;

import uniol.apt.adt.ts.State;

public class GeneralDiamondResult {
    private final boolean isGdiam;
    private final State witnessState;
    private final String witnessLabel1;
    private final String witnessLabel2;
    private final boolean witnessLabel1Forward;
    private final boolean witnessLabel2Forward;

    public GeneralDiamondResult() {
        this.isGdiam = true;
        this.witnessState = null;
        this.witnessLabel1 = "";
        this.witnessLabel2 = "";
        this.witnessLabel1Forward = true;
        this.witnessLabel2Forward = true;
    }

    public GeneralDiamondResult(State witnessState, String label1, String label2, boolean label1Forward, boolean label2Forward) {
        this.isGdiam = false;
        this.witnessState = witnessState;
        this.witnessLabel1 = label1;
        this.witnessLabel2 = label2;
        this.witnessLabel1Forward = label1Forward;
        this.witnessLabel2Forward = label2Forward;
    }

    public State getWitnessState() {
        return this.witnessState;
    }

    public String getWitnessLabel1() {
        return this.witnessLabel1;
    }

    public String getWitnessLabel2() {
        return this.witnessLabel2;
    }

    public boolean isWitnessLabel1Forward() {
        return this.witnessLabel1Forward;
    }

    public boolean isWitnessLabel2Forward() {
        return this.witnessLabel2Forward;
    }

    public boolean isGdiam() {
        return this.isGdiam;
    }

    public String getWitnessLabel1String() {
        return String.format("%s (%s)", this.witnessLabel1, this.witnessLabel1Forward ? "forward" : "backward");
    }

    public String getWitnessLabel2String() {
        return String.format("%s (%s)", this.witnessLabel2, this.witnessLabel2Forward ? "forward" : "backward");
    }

    public String toString() {
        return "GeneralDiamondResult [isGdiam=" + this.isGdiam + ", witnessState=" + this.witnessState + ", label1=" + this.witnessLabel1 + ", label2=" + this.witnessLabel2 + ", label1Forward=" + this.witnessLabel1Forward + ", label2Forward=" + this.witnessLabel2Forward + "]";
    }
}

