/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.factorization;

import java.util.HashSet;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.factorization.GeneralDiamond;
import uniol.apt.analysis.factorization.GeneralDiamondResult;
import uniol.apt.analysis.language.Word;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class GeneralDiamondModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getName() {
        return "gdiam";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("lts", TransitionSystem.class, "The LTS to check", new String[0]);
        inputSpec.addParameter("T'", Word.class, "Set of labels to check", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("T'-gdiam", Boolean.class, "success");
        outputSpec.addReturnValue("witness_state", State.class, new String[0]);
        outputSpec.addReturnValue("witness_first_label", String.class, new String[0]);
        outputSpec.addReturnValue("witness_second_label", String.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        TransitionSystem ts = input.getParameter("lts", TransitionSystem.class);
        Word tPrimeWord = input.getParameter("T'", Word.class);
        HashSet<String> tPrime = new HashSet<String>(tPrimeWord);
        if (!ts.getAlphabet().containsAll(tPrime)) {
            throw new ModuleException(String.format("At least one of the supplied labels is not part of the LTS label-set.", new Object[0]));
        }
        GeneralDiamondResult r = GeneralDiamond.checkGdiam(ts, tPrime);
        output.setReturnValue("T'-gdiam", Boolean.class, r.isGdiam());
        if (!r.isGdiam()) {
            output.setReturnValue("witness_state", State.class, r.getWitnessState());
            output.setReturnValue("witness_first_label", String.class, r.getWitnessLabel1String());
            output.setReturnValue("witness_second_label", String.class, r.getWitnessLabel2String());
        }
    }

    @Override
    public String getShortDescription() {
        return "Check if a LTS is a T'-gdiam";
    }

    @Override
    public String getLongDescription() {
        return "Check if for the given LTS = (S, ->, T, s0) for each pair of labels a in T', b in T\\T' the general diamond property holds.";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.LTS};
    }
}

