/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.factorization;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.factorization.GeneralDiamondResult;
import uniol.apt.util.Pair;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class GeneralDiamond {
    private GeneralDiamond() {
    }

    public static boolean isGdiam(TransitionSystem ts, Set<String> labelSubset) {
        return GeneralDiamond.checkGdiam(ts, labelSubset).isGdiam();
    }

    public static GeneralDiamondResult checkGdiam(TransitionSystem ts, Set<String> tPrime) {
        HashSet<String> notLabelSubset = new HashSet<String>(ts.getAlphabet());
        notLabelSubset.removeAll(tPrime);
        for (String t : tPrime) {
            for (String u : notLabelSubset) {
                GeneralDiamondResult r = GeneralDiamond.checkGdiam(ts, t, u);
                if (r.isGdiam()) continue;
                return r;
            }
        }
        return new GeneralDiamondResult();
    }

    public static boolean isGdiam(TransitionSystem ts, String a, String b) {
        return GeneralDiamond.checkGdiam(ts, a, b).isGdiam();
    }

    public static GeneralDiamondResult checkGdiam(TransitionSystem ts, String a, String b) {
        for (State s : ts.getNodes()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            Set<Pair<State, Boolean>> s1Set = GeneralDiamond.getGenerallyReachable(s, a);
            Set<Pair<State, Boolean>> s2Set = GeneralDiamond.getGenerallyReachable(s, b);
            for (Pair<State, Boolean> p1 : s1Set) {
                for (Pair<State, Boolean> p2 : s2Set) {
                    Set<State> s2SetPrime;
                    Set<State> s1SetPrime = GeneralDiamond.getReachableWithDirection(p1.getFirst(), b, p2.getSecond());
                    if (!Collections.disjoint(s1SetPrime, s2SetPrime = GeneralDiamond.getReachableWithDirection(p2.getFirst(), a, p1.getSecond()))) continue;
                    return new GeneralDiamondResult(s, a, b, p1.getSecond(), p2.getSecond());
                }
            }
        }
        return new GeneralDiamondResult();
    }

    private static Set<Pair<State, Boolean>> getGenerallyReachable(State s, String label) {
        HashSet<Pair<State, Boolean>> result = new HashSet<Pair<State, Boolean>>();
        for (State sPost : s.getPostsetNodesByLabel(label)) {
            result.add(new Pair<State, Boolean>(sPost, true));
        }
        for (State sPre : s.getPresetNodesByLabel(label)) {
            result.add(new Pair<State, Boolean>(sPre, false));
        }
        return result;
    }

    private static Set<State> getReachableWithDirection(State s, String label, boolean forward) {
        if (forward) {
            return s.getPostsetNodesByLabel(label);
        }
        return s.getPresetNodesByLabel(label);
    }
}

