/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.factorization;

import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.connectivity.Connectivity;
import uniol.apt.analysis.factorization.Factorization;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class FactorizationModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getName() {
        return "factorize";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("lts", TransitionSystem.class, "The connected LTS that should factorized", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("is_product", Boolean.class, "success");
        outputSpec.addReturnValue("factor1", TransitionSystem.class, "raw", "file");
        outputSpec.addReturnValue("factor2", TransitionSystem.class, "raw", "file");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        TransitionSystem ts = input.getParameter("lts", TransitionSystem.class);
        if (!Connectivity.isWeaklyConnected(ts)) {
            throw new ModuleException("LTS factorization can only be performed on connected LTS");
        }
        Factorization factorization = new Factorization(ts);
        boolean result = factorization.hasFactors();
        output.setReturnValue("is_product", Boolean.class, result);
        if (result) {
            output.setReturnValue("factor1", TransitionSystem.class, factorization.getFactor1());
            output.setReturnValue("factor2", TransitionSystem.class, factorization.getFactor2());
        }
    }

    @Override
    public String getShortDescription() {
        return "Decompose a LTS into its factors (if possible)";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.LTS};
    }
}

