/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.factorization;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.factorization.GeneralDiamond;
import uniol.apt.analysis.factorization.LabelSeparation;
import uniol.apt.util.Pair;
import uniol.apt.util.PowerSet;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class Factorization {
    private final TransitionSystem ts;
    private boolean hasFactors;
    private TransitionSystem factor1;
    private TransitionSystem factor2;

    public Factorization(TransitionSystem ts) {
        this.ts = ts;
        this.hasFactors = this.factorize();
    }

    public TransitionSystem getFactor1() {
        return this.factor1;
    }

    public TransitionSystem getFactor2() {
        return this.factor2;
    }

    public boolean hasFactors() {
        return this.hasFactors;
    }

    private boolean factorize() {
        for (Collection<String> collection : PowerSet.powerSet(this.ts.getAlphabet())) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            if (collection.isEmpty() || collection.size() == this.ts.getAlphabet().size() || !this.isGdiamAndSeparated(collection)) continue;
            this.createFactors(collection);
            return true;
        }
        return false;
    }

    private void createFactors(Collection<String> tPrime) {
        HashSet<String> t1 = new HashSet<String>(tPrime);
        HashSet<String> t2 = new HashSet<String>(this.ts.getAlphabet());
        t2.removeAll(tPrime);
        this.factor1 = Factorization.createFactor(this.ts, t1);
        this.factor2 = Factorization.createFactor(this.ts, t2);
    }

    static TransitionSystem createFactor(TransitionSystem ts, Set<String> labels) {
        return new TSFactor(ts, labels).factor;
    }

    private boolean isGdiamAndSeparated(Collection<String> tPrime) {
        HashSet<String> set = new HashSet<String>(tPrime);
        return GeneralDiamond.isGdiam(this.ts, set) && LabelSeparation.isSeparated(this.ts, set);
    }

    private static class TSFactor {
        private final TransitionSystem factor = new TransitionSystem();
        private final Deque<Pair<State, State>> queue = new ArrayDeque<Pair<State, State>>();
        private final Map<State, State> mapped = new HashMap<State, State>();

        private TSFactor(TransitionSystem ts, Set<String> labels) {
            this.factor.setInitialState(this.addState(ts.getInitialState()));
            while (!this.queue.isEmpty()) {
                Pair<State, State> pair = this.queue.pop();
                State originalState = pair.getFirst();
                State newState = pair.getSecond();
                for (Arc a : originalState.getPostsetEdges()) {
                    if (!labels.contains(a.getLabel())) continue;
                    Arc newArc = this.factor.createArc(newState, this.addState((State)a.getTarget()), a.getLabel());
                    newArc.copyExtensions(a);
                }
                for (Arc a : originalState.getPresetEdges()) {
                    if (!labels.contains(a.getLabel())) continue;
                    this.addState((State)a.getSource());
                }
            }
        }

        private State addState(State originalState) {
            State newState = this.mapped.get(originalState);
            if (newState == null) {
                newState = this.factor.createState(originalState);
                this.mapped.put(originalState, newState);
                this.queue.push(new Pair<State, State>(originalState, newState));
            }
            return newState;
        }
    }
}

