/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.exception;

import uniol.apt.adt.ts.ParikhVector;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.exception.PreconditionFailedException;

public class NonDisjointCyclesException
extends PreconditionFailedException {
    public static final long serialVersionUID = 1L;
    private final ParikhVector pv1;
    private final ParikhVector pv2;

    public NonDisjointCyclesException(TransitionSystem ts, ParikhVector pv1, ParikhVector pv2) {
        super("Transition system " + ts.getName() + " does not have disjoint small cycles, but this property is required. For example, there is a cycle with Parikh vector " + pv1 + " and another cycle with Parikh vector " + pv2 + ".");
        assert (!pv1.sameOrMutuallyDisjoint(pv2));
        this.pv1 = pv1;
        this.pv2 = pv2;
    }

    public ParikhVector getPV1() {
        return this.pv1;
    }

    public ParikhVector getPV2() {
        return this.pv2;
    }
}

