/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.deterministic;

import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.deterministic.Deterministic;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class DeterministicModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getName() {
        return "deterministic";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("lts", TransitionSystem.class, "The LTS that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("deterministic", Boolean.class, "deterministic", "success");
        outputSpec.addReturnValue("state", State.class, new String[0]);
        outputSpec.addReturnValue("label", String.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        TransitionSystem ts = input.getParameter("lts", TransitionSystem.class);
        Deterministic deterministic = new Deterministic(ts);
        output.setReturnValue("deterministic", Boolean.class, deterministic.isDeterministic());
        output.setReturnValue("state", State.class, deterministic.getNode());
        output.setReturnValue("label", String.class, deterministic.getLabel());
    }

    @Override
    public String getShortDescription() {
        return "Check if a LTS is deterministic";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.LTS};
    }
}

