/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.deterministic;

import java.util.HashSet;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.exception.NonDeterministicException;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class Deterministic {
    private final TransitionSystem ts;
    private boolean deterministic = false;
    private String label = null;
    private State node = null;
    private boolean forward;

    public Deterministic(TransitionSystem ts) {
        this(ts, true);
    }

    public Deterministic(TransitionSystem ts, boolean forward) {
        this.ts = ts;
        this.forward = forward;
        this.check();
    }

    private void check() {
        HashSet<StateNameWithLabel> statesLabels = new HashSet<StateNameWithLabel>();
        for (Arc arc : this.ts.getEdges()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            String state = this.forward ? arc.getSourceId() : arc.getTargetId();
            StateNameWithLabel stateLabel = new StateNameWithLabel(state, arc.getLabel());
            if (statesLabels.contains(stateLabel)) {
                this.deterministic = false;
                this.label = stateLabel.label;
                this.node = this.forward ? (State)arc.getSource() : (State)arc.getTarget();
                return;
            }
            statesLabels.add(stateLabel);
        }
        this.deterministic = true;
        this.label = null;
        this.node = null;
    }

    public void throwIfNonDeterministic() throws NonDeterministicException {
        if (this.deterministic) {
            return;
        }
        throw new NonDeterministicException(this.ts, this.node, this.label, this.forward);
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public String getLabel() {
        return this.label;
    }

    public State getNode() {
        return this.node;
    }

    private static class StateNameWithLabel {
        final String stateName;
        final String label;

        public StateNameWithLabel(String arcName, String label) {
            this.stateName = arcName;
            this.label = label;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.stateName == null ? 0 : this.stateName.hashCode());
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            return result;
        }

        public boolean equals(Object object) {
            if (!(object instanceof StateNameWithLabel)) {
                return false;
            }
            StateNameWithLabel other = (StateNameWithLabel)object;
            if (!this.stateName.equals(other.stateName)) {
                return false;
            }
            return this.label.equals(other.label);
        }
    }
}

