/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.cycles.lts;

import uniol.apt.adt.PetriNetOrTransitionSystem;
import uniol.apt.adt.ts.ParikhVector;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.cycles.lts.PrimeCycleProperty;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class PrimeCyclePropertyModule
extends AbstractModule
implements InterruptibleModule {
    private static final String DESCRIPTION = "Check if the give Petri net or LTS fulfills the prime cycle property.";
    private static final String NAME = "prime_cycle_property";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("graph", PetriNetOrTransitionSystem.class, "The Petri net or LTS that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue(NAME, Boolean.class, "success");
        outputSpec.addReturnValue("counter_example", ParikhVector.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNetOrTransitionSystem g = input.getParameter("graph", PetriNetOrTransitionSystem.class);
        TransitionSystem ts = g.getReachabilityLTS();
        ParikhVector pv = new PrimeCycleProperty().check(ts);
        if (pv != null) {
            output.setReturnValue(NAME, Boolean.class, false);
            output.setReturnValue("counter_example", ParikhVector.class, pv);
        } else {
            output.setReturnValue(NAME, Boolean.class, true);
        }
    }

    @Override
    public String getShortDescription() {
        return DESCRIPTION;
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN, Category.LTS};
    }
}

