/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.cycles.lts;

import java.util.Set;
import uniol.apt.adt.ts.ParikhVector;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.cycles.lts.ComputeSmallestCycles;
import uniol.apt.analysis.cycles.lts.CyclePV;
import uniol.apt.util.MathTools;

public class PrimeCycleProperty {
    public ParikhVector check(TransitionSystem ts) {
        Set<? extends CyclePV> parikhs = new ComputeSmallestCycles().computePVsOfSmallestCycles(ts);
        for (CyclePV cyclePV : parikhs) {
            ParikhVector pv = cyclePV.getParikhVector();
            if (this.isPrimeCyclePV(pv)) continue;
            return pv;
        }
        return null;
    }

    private boolean isPrimeCyclePV(ParikhVector pv) {
        int gcd = 0;
        for (String event : pv.getLabels()) {
            gcd = MathTools.gcd(gcd, pv.get(event));
        }
        return gcd == 1;
    }
}

