/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.cycles.lts;

import java.util.Set;
import uniol.apt.adt.PetriNetOrTransitionSystem;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.cycles.lts.ComputeSmallestCycles;
import uniol.apt.analysis.cycles.lts.CyclePV;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class PVsOfSmallestCyclesModule
extends AbstractModule
implements InterruptibleModule {
    private static final String DESCRIPTION = "Compute parikh vectors of smallest cycles of a Petri net or LTS";
    private static final String NAME = "compute_pvs";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("graph", PetriNetOrTransitionSystem.class, "The Petri net or LTS that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("output_format", String.class, new String[0]);
        outputSpec.addReturnValue("output", Set.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNetOrTransitionSystem g = input.getParameter("graph", PetriNetOrTransitionSystem.class);
        ComputeSmallestCycles prog = new ComputeSmallestCycles();
        TransitionSystem ts = g.getReachabilityLTS();
        Set<? extends CyclePV> parikhs = prog.computePVsOfSmallestCycles(ts);
        output.setReturnValue("output", Set.class, parikhs);
        output.setReturnValue("output_format", String.class, "[(cycle, parikh vector), ... ]");
    }

    @Override
    public String getShortDescription() {
        return DESCRIPTION;
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN, Category.LTS};
    }
}

