/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.cycles.lts;

import uniol.apt.adt.PetriNetOrTransitionSystem;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.cycles.lts.ComputeSmallestCycles;
import uniol.apt.analysis.cycles.lts.CycleCounterExample;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class CyclesHaveSamePVModule
extends AbstractModule
implements InterruptibleModule {
    private static final String SHORTDESCRIPTION = "Check if the smallest cycles of Petri net or LTS have the same parikh vector";
    private static final String LONGDESCRIPTION = "Check if the smallest cycles of Petri net or LTS have the same parikh vector";
    private static final String TITLE = "SmallestCyclesHaveSameParikhVectors";
    private static final String NAME = "cycles_same_pv";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("graph", PetriNetOrTransitionSystem.class, "The LTS or Petri net that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("out", Boolean.class, "success");
        outputSpec.addReturnValue("counterExamples", CycleCounterExample.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNetOrTransitionSystem g = input.getParameter("graph", PetriNetOrTransitionSystem.class);
        ComputeSmallestCycles prog = new ComputeSmallestCycles();
        TransitionSystem ts = g.getReachabilityLTS();
        boolean ret = prog.checkSamePVs(ts);
        CycleCounterExample ex = prog.getCounterExample();
        if (!ret) {
            output.setReturnValue("counterExamples", CycleCounterExample.class, ex);
        }
        output.setReturnValue("out", Boolean.class, ret);
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public String getShortDescription() {
        return "Check if the smallest cycles of Petri net or LTS have the same parikh vector";
    }

    @Override
    public String getLongDescription() {
        return "Check if the smallest cycles of Petri net or LTS have the same parikh vector";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN, Category.LTS};
    }
}

