/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.cycles.lts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.ParikhVector;
import uniol.apt.adt.ts.State;
import uniol.apt.analysis.cycles.lts.CyclePV;
import uniol.apt.analysis.presynthesis.pps.Path;

public class Cycle
extends CyclePV {
    private final List<Arc> arcs;
    private final List<State> nodes;

    public Cycle(List<State> nodes, List<Arc> arcs) {
        super(new ParikhVector(new Path(arcs).getLabels()));
        this.arcs = Collections.unmodifiableList(new ArrayList<Arc>(arcs));
        this.nodes = Collections.unmodifiableList(new ArrayList<State>(nodes));
    }

    public List<Arc> getArcs() {
        return this.arcs;
    }

    public List<State> getNodes() {
        return this.nodes;
    }

    public List<String> getNodeIDs() {
        ArrayList<String> result = new ArrayList<String>(this.nodes.size());
        for (State state : this.nodes) {
            result.add(state.getId());
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 31 * this.nodes.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CyclePV) || !super.equals(o)) {
            return false;
        }
        return this.nodes.equals(((Cycle)o).nodes);
    }

    @Override
    public String toString() {
        return "Cycle: " + this.getNodeIDs().toString() + " Parikhvector: " + this.getParikhVector().toString();
    }
}

