/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.cycles.lts;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.ParikhVector;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.cycles.CycleCallback;
import uniol.apt.analysis.cycles.CycleSearch;
import uniol.apt.analysis.cycles.CycleSearchViaChords;
import uniol.apt.analysis.cycles.lts.Cycle;
import uniol.apt.analysis.cycles.lts.CycleCounterExample;
import uniol.apt.analysis.cycles.lts.CyclePV;
import uniol.apt.analysis.exception.NonDisjointCyclesException;
import uniol.apt.analysis.exception.PreconditionFailedException;

public class ComputeSmallestCycles {
    private CycleCounterExample counterExample;

    public Set<? extends CyclePV> computePVsOfSmallestCycles(TransitionSystem ts) {
        return this.computePVsOfSmallestCycles(ts, true);
    }

    public Set<Cycle> computePVsOfSmallestCyclesViaCycleSearch(TransitionSystem ts) {
        return this.computePVsOfSmallestCyclesViaCycleSearch(ts, true);
    }

    public boolean checkSamePVs(TransitionSystem ts) {
        return this.checkSamePVs(ts, true);
    }

    public Set<? extends CyclePV> computePVsOfSmallestCycles(TransitionSystem ts, boolean smallest) {
        if (smallest) {
            try {
                return this.computePVsOfSmallestCyclesViaChords(ts);
            }
            catch (PreconditionFailedException preconditionFailedException) {
                // empty catch block
            }
        }
        return this.computePVsOfSmallestCyclesViaCycleSearch(ts, smallest);
    }

    public Set<Cycle> computePVsOfSmallestCyclesViaCycleSearch(TransitionSystem ts, final boolean smallest) {
        final HashSet<Cycle> cycles = new HashSet<Cycle>();
        new CycleSearch().searchCycles(ts, new CycleCallback<TransitionSystem, Arc, State>(){

            @Override
            public void cycleFound(List<State> nodes, List<Arc> edges) {
                Cycle newCycle = new Cycle(nodes, edges);
                if (smallest) {
                    ParikhVector pv = newCycle.getParikhVector();
                    Iterator iter = cycles.iterator();
                    while (iter.hasNext()) {
                        Cycle cycle = (Cycle)iter.next();
                        int comp = cycle.getParikhVector().compare(pv).asInt();
                        if (comp < 0) {
                            return;
                        }
                        if (comp <= 0) continue;
                        iter.remove();
                    }
                }
                cycles.add(newCycle);
            }
        });
        return cycles;
    }

    public Set<CyclePV> computePVsOfSmallestCyclesViaChords(TransitionSystem ts) throws PreconditionFailedException {
        HashSet<CyclePV> result = new HashSet<CyclePV>();
        for (ParikhVector pv : new CycleSearchViaChords().searchCycles(ts)) {
            result.add(new CyclePV(pv));
        }
        return result;
    }

    public boolean checkSameOrMutallyDisjointPVs(TransitionSystem ts) {
        try {
            this.computePVsOfSmallestCyclesViaChords(ts);
            return true;
        }
        catch (NonDisjointCyclesException e) {
            this.counterExample = new CycleCounterExample(new CyclePV(e.getPV1()), new CyclePV(e.getPV2()));
            return false;
        }
        catch (PreconditionFailedException e) {
            return this.checkSameOrMutallyDisjointPVs(this.computePVsOfSmallestCyclesViaCycleSearch(ts, true));
        }
    }

    public boolean checkSamePVs(TransitionSystem ts, boolean smallest) {
        return this.checkSamePVs(this.computePVsOfSmallestCycles(ts, smallest));
    }

    public boolean checkSameOrMutallyDisjointPVs(Collection<? extends CyclePV> cycles) {
        this.counterExample = null;
        for (CyclePV cyclePV : cycles) {
            for (CyclePV cyclePV2 : cycles) {
                if (cyclePV == cyclePV2 || cyclePV.getParikhVector().sameOrMutuallyDisjoint(cyclePV2.getParikhVector())) continue;
                this.counterExample = new CycleCounterExample(cyclePV, cyclePV2);
                return false;
            }
        }
        return true;
    }

    public boolean checkSamePVs(Collection<? extends CyclePV> cycles) {
        this.counterExample = null;
        for (CyclePV cyclePV : cycles) {
            for (CyclePV cyclePV2 : cycles) {
                if (cyclePV == cyclePV2 || cyclePV.getParikhVector().equals(cyclePV2.getParikhVector())) continue;
                this.counterExample = new CycleCounterExample(cyclePV, cyclePV2);
                return false;
            }
        }
        return true;
    }

    public CycleCounterExample getCounterExample() {
        return this.counterExample;
    }
}

