/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.cycles;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.ParikhVector;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.deterministic.Deterministic;
import uniol.apt.analysis.exception.NonDisjointCyclesException;
import uniol.apt.analysis.exception.PreconditionFailedException;
import uniol.apt.analysis.persistent.PersistentTS;
import uniol.apt.analysis.totallyreachable.TotallyReachable;
import uniol.apt.util.SpanningTree;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class CycleSearchViaChords {
    public Set<ParikhVector> searchCycles(TransitionSystem ts) throws PreconditionFailedException {
        new Deterministic(ts).throwIfNonDeterministic();
        if (!new TotallyReachable(ts).isTotallyReachable()) {
            throw new PreconditionFailedException("Transition system " + ts.getName() + " is not totally reachable, only totally reachable inputs are allowed");
        }
        if (!new PersistentTS(ts).isPersistent()) {
            throw new PreconditionFailedException("Transition system " + ts.getName() + " is not persistent, only persistent inputs are allowed");
        }
        return this.findCyclesAround(this.findHomeState(ts));
    }

    private State findHomeState(TransitionSystem ts) {
        HashMap<State, Integer> dfsNumbers = new HashMap<State, Integer>();
        HashMap<State, Integer> minNumbers = new HashMap<State, Integer>();
        ArrayDeque<State> callers = new ArrayDeque<State>();
        HashSet<State> stackAsSet = new HashSet<State>();
        int counter = 0;
        State node = ts.getInitialState();
        counter = CycleSearchViaChords.visitNode(node, dfsNumbers, minNumbers, counter, stackAsSet);
        while (true) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            boolean done = true;
            for (State current : node.getPostsetNodes()) {
                if (!dfsNumbers.containsKey(current)) {
                    callers.addLast(node);
                    node = current;
                    counter = CycleSearchViaChords.visitNode(node, dfsNumbers, minNumbers, counter, stackAsSet);
                    done = false;
                    break;
                }
                if (!stackAsSet.contains(current) || (Integer)minNumbers.get(node) <= (Integer)minNumbers.get(current)) continue;
                minNumbers.put(node, Math.min((Integer)minNumbers.get(node), (Integer)dfsNumbers.get(current)));
            }
            if (!done) continue;
            if (((Integer)dfsNumbers.get(node)).equals(minNumbers.get(node))) {
                return node;
            }
            State next = (State)callers.removeLast();
            minNumbers.put(next, Math.min((Integer)minNumbers.get(next), (Integer)minNumbers.get(node)));
            node = next;
        }
    }

    private static int visitNode(State node, Map<State, Integer> dfsNumbers, Map<State, Integer> minNumbers, int counter, Set<State> stackAsSet) {
        assert (!dfsNumbers.containsKey(node));
        assert (!minNumbers.containsKey(node));
        dfsNumbers.put(node, ++counter);
        minNumbers.put(node, counter);
        boolean added = stackAsSet.add(node);
        assert (added);
        return counter;
    }

    private Set<ParikhVector> findCyclesAround(State homeState) throws PreconditionFailedException {
        SpanningTree<TransitionSystem, Arc, State> tree = SpanningTree.get(homeState.getGraph(), homeState);
        HashSet<ParikhVector> cyclesSeen = new HashSet<ParikhVector>();
        for (Arc chord : tree.getChords()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            ParikhVector pv = this.getPV(tree, chord);
            cyclesSeen.add(pv);
        }
        cyclesSeen.remove(new ParikhVector(new String[0]));
        return cyclesSeen;
    }

    private ParikhVector getPV(SpanningTree<TransitionSystem, Arc, State> tree, Arc chord) throws PreconditionFailedException {
        ParikhVector pv2;
        State commonAncestor = this.findCommonAncestor(tree, (State)chord.getSource(), (State)chord.getTarget());
        ParikhVector pv1 = this.getPV(tree, (State)chord.getSource(), commonAncestor).add(chord.getLabel());
        ParikhVector.Comparison comp = pv1.compare(pv2 = this.getPV(tree, (State)chord.getTarget(), commonAncestor));
        if (!comp.equals((Object)ParikhVector.Comparison.GREATER_THAN) && !comp.equals((Object)ParikhVector.Comparison.EQUAL)) {
            assert (comp.equals((Object)ParikhVector.Comparison.INCOMPARABLE));
            ParikhVector residual1 = pv1.residual(pv2);
            ParikhVector residual2 = pv2.residual(pv1);
            State residualsTarget = this.followPV((State)chord.getTarget(), residual1);
            ParikhVector restOfCycle = this.findPath(residualsTarget, (State)chord.getTarget());
            throw new NonDisjointCyclesException((TransitionSystem)chord.getGraph(), residual1.add(restOfCycle), residual2.add(restOfCycle));
        }
        return pv1.residual(pv2);
    }

    private State findCommonAncestor(SpanningTree<TransitionSystem, Arc, State> tree, State state1, State state2) {
        HashSet<State> predecessors1 = new HashSet<State>();
        HashSet<State> predecessors2 = new HashSet<State>();
        predecessors1.add(state1);
        predecessors2.add(state2);
        while (true) {
            if (state1 != null) {
                if (predecessors2.contains(state1 = tree.getPredecessor(state1))) {
                    return state1;
                }
                predecessors1.add(state1);
            }
            if (state2 == null) continue;
            if (predecessors1.contains(state2 = tree.getPredecessor(state2))) {
                return state2;
            }
            predecessors2.add(state2);
        }
    }

    private ParikhVector getPV(SpanningTree<TransitionSystem, Arc, State> tree, State state) {
        return this.getPV(tree, state, null);
    }

    private ParikhVector getPV(SpanningTree<TransitionSystem, Arc, State> tree, State state, State upTo) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Arc arc = tree.getPredecessorEdge(state);
        while (arc != null && !state.equals(upTo)) {
            String label = arc.getLabel();
            Integer value = (Integer)result.get(label);
            if (value == null) {
                result.put(label, 1);
            } else {
                result.put(label, value + 1);
            }
            state = (State)arc.getSource();
            arc = tree.getPredecessorEdge(state);
        }
        return new ParikhVector(result);
    }

    private State followPV(State state, ParikhVector pv) {
        for (String t : pv.getLabels()) {
            Set<State> targets = state.getPostsetNodesByLabel(t);
            Iterator<State> iterator = targets.iterator();
            if (!iterator.hasNext()) continue;
            State target = iterator.next();
            return this.followPV(target, pv.tryRemove(t, 1));
        }
        assert (new ParikhVector(new String[0]).equals(pv)) : pv;
        return state;
    }

    private ParikhVector findPath(State from, State to) {
        SpanningTree<TransitionSystem, Arc, State> tree = SpanningTree.get(from.getGraph(), from);
        assert (tree.isReachable(to));
        return this.getPV(tree, to);
    }
}

